/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Web Services resource event. Amazon Web Services resource events and metrics are analyzed by DevOps Guru to
 * find anomalous behavior and provide recommendations to improve your operational solutions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Event implements SdkPojo, Serializable, ToCopyableBuilder<Event.Builder, Event> {
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(Event::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Event::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Time")
            .getter(getter(Event::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSource").getter(getter(Event::eventSource)).setter(setter(Builder::eventSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Event::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(Event::dataSourceAsString)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> EVENT_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventClass").getter(getter(Event::eventClassAsString)).setter(setter(Builder::eventClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventClass").build()).build();

    private static final SdkField<List<EventResource>> RESOURCES_FIELD = SdkField
            .<List<EventResource>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(Event::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_COLLECTION_FIELD,
            ID_FIELD, TIME_FIELD, EVENT_SOURCE_FIELD, NAME_FIELD, DATA_SOURCE_FIELD, EVENT_CLASS_FIELD, RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResourceCollection resourceCollection;

    private final String id;

    private final Instant time;

    private final String eventSource;

    private final String name;

    private final String dataSource;

    private final String eventClass;

    private final List<EventResource> resources;

    private Event(BuilderImpl builder) {
        this.resourceCollection = builder.resourceCollection;
        this.id = builder.id;
        this.time = builder.time;
        this.eventSource = builder.eventSource;
        this.name = builder.name;
        this.dataSource = builder.dataSource;
        this.eventClass = builder.eventClass;
        this.resources = builder.resources;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    /**
     * <p>
     * The ID of the event.
     * </p>
     * 
     * @return The ID of the event.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A <code>Timestamp</code> that specifies the time the event occurred.
     * </p>
     * 
     * @return A <code>Timestamp</code> that specifies the time the event occurred.
     */
    public final Instant time() {
        return time;
    }

    /**
     * <p>
     * The Amazon Web Services source that emitted the event.
     * </p>
     * 
     * @return The Amazon Web Services source that emitted the event.
     */
    public final String eventSource() {
        return eventSource;
    }

    /**
     * <p>
     * The name of the event.
     * </p>
     * 
     * @return The name of the event.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the
     * event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link EventDataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis
     *         found the event.
     * @see EventDataSource
     */
    public final EventDataSource dataSource() {
        return EventDataSource.fromValue(dataSource);
    }

    /**
     * <p>
     * The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the
     * event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link EventDataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis
     *         found the event.
     * @see EventDataSource
     */
    public final String dataSourceAsString() {
        return dataSource;
    }

    /**
     * <p>
     * The class of the event. The class specifies what the event is related to, such as an infrastructure change, a
     * deployment, or a schema change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventClass} will
     * return {@link EventClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventClassAsString}.
     * </p>
     * 
     * @return The class of the event. The class specifies what the event is related to, such as an infrastructure
     *         change, a deployment, or a schema change.
     * @see EventClass
     */
    public final EventClass eventClass() {
        return EventClass.fromValue(eventClass);
    }

    /**
     * <p>
     * The class of the event. The class specifies what the event is related to, such as an infrastructure change, a
     * deployment, or a schema change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventClass} will
     * return {@link EventClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventClassAsString}.
     * </p>
     * 
     * @return The class of the event. The class specifies what the event is related to, such as an infrastructure
     *         change, a deployment, or a schema change.
     * @see EventClass
     */
    public final String eventClassAsString() {
        return eventClass;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An <code>EventResource</code> object that contains information about the resource that emitted the event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return An <code>EventResource</code> object that contains information about the resource that emitted the event.
     */
    public final List<EventResource> resources() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event) obj;
        return Objects.equals(resourceCollection(), other.resourceCollection()) && Objects.equals(id(), other.id())
                && Objects.equals(time(), other.time()) && Objects.equals(eventSource(), other.eventSource())
                && Objects.equals(name(), other.name()) && Objects.equals(dataSourceAsString(), other.dataSourceAsString())
                && Objects.equals(eventClassAsString(), other.eventClassAsString()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Event").add("ResourceCollection", resourceCollection()).add("Id", id()).add("Time", time())
                .add("EventSource", eventSource()).add("Name", name()).add("DataSource", dataSourceAsString())
                .add("EventClass", eventClassAsString()).add("Resources", hasResources() ? resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        case "EventSource":
            return Optional.ofNullable(clazz.cast(eventSource()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSourceAsString()));
        case "EventClass":
            return Optional.ofNullable(clazz.cast(eventClassAsString()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceCollection", RESOURCE_COLLECTION_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Time", TIME_FIELD);
        map.put("EventSource", EVENT_SOURCE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("EventClass", EVENT_CLASS_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Event> {
        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceCollection.Builder} avoiding the
         * need to create one manually via {@link ResourceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }

        /**
         * <p>
         * The ID of the event.
         * </p>
         * 
         * @param id
         *        The ID of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A <code>Timestamp</code> that specifies the time the event occurred.
         * </p>
         * 
         * @param time
         *        A <code>Timestamp</code> that specifies the time the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);

        /**
         * <p>
         * The Amazon Web Services source that emitted the event.
         * </p>
         * 
         * @param eventSource
         *        The Amazon Web Services source that emitted the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The name of the event.
         * </p>
         * 
         * @param name
         *        The name of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found
         * the event.
         * </p>
         * 
         * @param dataSource
         *        The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis
         *        found the event.
         * @see EventDataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventDataSource
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found
         * the event.
         * </p>
         * 
         * @param dataSource
         *        The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis
         *        found the event.
         * @see EventDataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventDataSource
         */
        Builder dataSource(EventDataSource dataSource);

        /**
         * <p>
         * The class of the event. The class specifies what the event is related to, such as an infrastructure change, a
         * deployment, or a schema change.
         * </p>
         * 
         * @param eventClass
         *        The class of the event. The class specifies what the event is related to, such as an infrastructure
         *        change, a deployment, or a schema change.
         * @see EventClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventClass
         */
        Builder eventClass(String eventClass);

        /**
         * <p>
         * The class of the event. The class specifies what the event is related to, such as an infrastructure change, a
         * deployment, or a schema change.
         * </p>
         * 
         * @param eventClass
         *        The class of the event. The class specifies what the event is related to, such as an infrastructure
         *        change, a deployment, or a schema change.
         * @see EventClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventClass
         */
        Builder eventClass(EventClass eventClass);

        /**
         * <p>
         * An <code>EventResource</code> object that contains information about the resource that emitted the event.
         * </p>
         * 
         * @param resources
         *        An <code>EventResource</code> object that contains information about the resource that emitted the
         *        event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<EventResource> resources);

        /**
         * <p>
         * An <code>EventResource</code> object that contains information about the resource that emitted the event.
         * </p>
         * 
         * @param resources
         *        An <code>EventResource</code> object that contains information about the resource that emitted the
         *        event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(EventResource... resources);

        /**
         * <p>
         * An <code>EventResource</code> object that contains information about the resource that emitted the event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.EventResource.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.devopsguru.model.EventResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.EventResource.Builder#build()} is called immediately
         * and its result is passed to {@link #resources(List<EventResource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.EventResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<EventResource>)
         */
        Builder resources(Consumer<EventResource.Builder>... resources);
    }

    static final class BuilderImpl implements Builder {
        private ResourceCollection resourceCollection;

        private String id;

        private Instant time;

        private String eventSource;

        private String name;

        private String dataSource;

        private String eventClass;

        private List<EventResource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            resourceCollection(model.resourceCollection);
            id(model.id);
            time(model.time);
            eventSource(model.eventSource);
            name(model.name);
            dataSource(model.dataSource);
            eventClass(model.eventClass);
            resources(model.resources);
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getTime() {
            return time;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final String getEventSource() {
            return eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDataSource() {
            return dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(EventDataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final String getEventClass() {
            return eventClass;
        }

        public final void setEventClass(String eventClass) {
            this.eventClass = eventClass;
        }

        @Override
        public final Builder eventClass(String eventClass) {
            this.eventClass = eventClass;
            return this;
        }

        @Override
        public final Builder eventClass(EventClass eventClass) {
            this.eventClass(eventClass == null ? null : eventClass.toString());
            return this;
        }

        public final List<EventResource.Builder> getResources() {
            List<EventResource.Builder> result = EventResourcesCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<EventResource.BuilderImpl> resources) {
            this.resources = EventResourcesCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<EventResource> resources) {
            this.resources = EventResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(EventResource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<EventResource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> EventResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Event build() {
            return new Event(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
