/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationOverviewResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<DescribeOrganizationOverviewResponse.Builder, DescribeOrganizationOverviewResponse> {
    private static final SdkField<Integer> REACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReactiveInsights").getter(getter(DescribeOrganizationOverviewResponse::reactiveInsights))
            .setter(setter(Builder::reactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveInsights").build()).build();

    private static final SdkField<Integer> PROACTIVE_INSIGHTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProactiveInsights").getter(getter(DescribeOrganizationOverviewResponse::proactiveInsights))
            .setter(setter(Builder::proactiveInsights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveInsights").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REACTIVE_INSIGHTS_FIELD,
            PROACTIVE_INSIGHTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer reactiveInsights;

    private final Integer proactiveInsights;

    private DescribeOrganizationOverviewResponse(BuilderImpl builder) {
        super(builder);
        this.reactiveInsights = builder.reactiveInsights;
        this.proactiveInsights = builder.proactiveInsights;
    }

    /**
     * <p>
     * An integer that specifies the number of open reactive insights in your Amazon Web Services account.
     * </p>
     * 
     * @return An integer that specifies the number of open reactive insights in your Amazon Web Services account.
     */
    public final Integer reactiveInsights() {
        return reactiveInsights;
    }

    /**
     * <p>
     * An integer that specifies the number of open proactive insights in your Amazon Web Services account.
     * </p>
     * 
     * @return An integer that specifies the number of open proactive insights in your Amazon Web Services account.
     */
    public final Integer proactiveInsights() {
        return proactiveInsights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(proactiveInsights());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationOverviewResponse)) {
            return false;
        }
        DescribeOrganizationOverviewResponse other = (DescribeOrganizationOverviewResponse) obj;
        return Objects.equals(reactiveInsights(), other.reactiveInsights())
                && Objects.equals(proactiveInsights(), other.proactiveInsights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrganizationOverviewResponse").add("ReactiveInsights", reactiveInsights())
                .add("ProactiveInsights", proactiveInsights()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReactiveInsights":
            return Optional.ofNullable(clazz.cast(reactiveInsights()));
        case "ProactiveInsights":
            return Optional.ofNullable(clazz.cast(proactiveInsights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReactiveInsights", REACTIVE_INSIGHTS_FIELD);
        map.put("ProactiveInsights", PROACTIVE_INSIGHTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationOverviewResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationOverviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationOverviewResponse> {
        /**
         * <p>
         * An integer that specifies the number of open reactive insights in your Amazon Web Services account.
         * </p>
         * 
         * @param reactiveInsights
         *        An integer that specifies the number of open reactive insights in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveInsights(Integer reactiveInsights);

        /**
         * <p>
         * An integer that specifies the number of open proactive insights in your Amazon Web Services account.
         * </p>
         * 
         * @param proactiveInsights
         *        An integer that specifies the number of open proactive insights in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveInsights(Integer proactiveInsights);
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private Integer reactiveInsights;

        private Integer proactiveInsights;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationOverviewResponse model) {
            super(model);
            reactiveInsights(model.reactiveInsights);
            proactiveInsights(model.proactiveInsights);
        }

        public final Integer getReactiveInsights() {
            return reactiveInsights;
        }

        public final void setReactiveInsights(Integer reactiveInsights) {
            this.reactiveInsights = reactiveInsights;
        }

        @Override
        public final Builder reactiveInsights(Integer reactiveInsights) {
            this.reactiveInsights = reactiveInsights;
            return this;
        }

        public final Integer getProactiveInsights() {
            return proactiveInsights;
        }

        public final void setProactiveInsights(Integer proactiveInsights) {
            this.proactiveInsights = proactiveInsights;
        }

        @Override
        public final Builder proactiveInsights(Integer proactiveInsights) {
            this.proactiveInsights = proactiveInsights;
            return this;
        }

        @Override
        public DescribeOrganizationOverviewResponse build() {
            return new DescribeOrganizationOverviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
