/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationOverviewRequest extends DevOpsGuruRequest implements
        ToCopyableBuilder<DescribeOrganizationOverviewRequest.Builder, DescribeOrganizationOverviewRequest> {
    private static final SdkField<Instant> FROM_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FromTime").getter(getter(DescribeOrganizationOverviewRequest::fromTime))
            .setter(setter(Builder::fromTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromTime").build()).build();

    private static final SdkField<Instant> TO_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ToTime").getter(getter(DescribeOrganizationOverviewRequest::toTime)).setter(setter(Builder::toTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToTime").build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(DescribeOrganizationOverviewRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OrganizationalUnitIds")
            .getter(getter(DescribeOrganizationOverviewRequest::organizationalUnitIds))
            .setter(setter(Builder::organizationalUnitIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_TIME_FIELD,
            TO_TIME_FIELD, ACCOUNT_IDS_FIELD, ORGANIZATIONAL_UNIT_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant fromTime;

    private final Instant toTime;

    private final List<String> accountIds;

    private final List<String> organizationalUnitIds;

    private DescribeOrganizationOverviewRequest(BuilderImpl builder) {
        super(builder);
        this.fromTime = builder.fromTime;
        this.toTime = builder.toTime;
        this.accountIds = builder.accountIds;
        this.organizationalUnitIds = builder.organizationalUnitIds;
    }

    /**
     * <p>
     * The start of the time range passed in. The start time granularity is at the day level. The floor of the start
     * time is used. Returned information occurred after this day.
     * </p>
     * 
     * @return The start of the time range passed in. The start time granularity is at the day level. The floor of the
     *         start time is used. Returned information occurred after this day.
     */
    public final Instant fromTime() {
        return fromTime;
    }

    /**
     * <p>
     * The end of the time range passed in. The start time granularity is at the day level. The floor of the start time
     * is used. Returned information occurred before this day. If this is not specified, then the current day is used.
     * </p>
     * 
     * @return The end of the time range passed in. The start time granularity is at the day level. The floor of the
     *         start time is used. Returned information occurred before this day. If this is not specified, then the
     *         current day is used.
     */
    public final Instant toTime() {
        return toTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationalUnitIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrganizationalUnitIds() {
        return organizationalUnitIds != null && !(organizationalUnitIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the organizational unit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationalUnitIds} method.
     * </p>
     * 
     * @return The ID of the organizational unit.
     */
    public final List<String> organizationalUnitIds() {
        return organizationalUnitIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fromTime());
        hashCode = 31 * hashCode + Objects.hashCode(toTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnitIds() ? organizationalUnitIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationOverviewRequest)) {
            return false;
        }
        DescribeOrganizationOverviewRequest other = (DescribeOrganizationOverviewRequest) obj;
        return Objects.equals(fromTime(), other.fromTime()) && Objects.equals(toTime(), other.toTime())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasOrganizationalUnitIds() == other.hasOrganizationalUnitIds()
                && Objects.equals(organizationalUnitIds(), other.organizationalUnitIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrganizationOverviewRequest").add("FromTime", fromTime()).add("ToTime", toTime())
                .add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("OrganizationalUnitIds", hasOrganizationalUnitIds() ? organizationalUnitIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromTime":
            return Optional.ofNullable(clazz.cast(fromTime()));
        case "ToTime":
            return Optional.ofNullable(clazz.cast(toTime()));
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "OrganizationalUnitIds":
            return Optional.ofNullable(clazz.cast(organizationalUnitIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FromTime", FROM_TIME_FIELD);
        map.put("ToTime", TO_TIME_FIELD);
        map.put("AccountIds", ACCOUNT_IDS_FIELD);
        map.put("OrganizationalUnitIds", ORGANIZATIONAL_UNIT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationOverviewRequest, T> g) {
        return obj -> g.apply((DescribeOrganizationOverviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationOverviewRequest> {
        /**
         * <p>
         * The start of the time range passed in. The start time granularity is at the day level. The floor of the start
         * time is used. Returned information occurred after this day.
         * </p>
         * 
         * @param fromTime
         *        The start of the time range passed in. The start time granularity is at the day level. The floor of
         *        the start time is used. Returned information occurred after this day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromTime(Instant fromTime);

        /**
         * <p>
         * The end of the time range passed in. The start time granularity is at the day level. The floor of the start
         * time is used. Returned information occurred before this day. If this is not specified, then the current day
         * is used.
         * </p>
         * 
         * @param toTime
         *        The end of the time range passed in. The start time granularity is at the day level. The floor of the
         *        start time is used. Returned information occurred before this day. If this is not specified, then the
         *        current day is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toTime(Instant toTime);

        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * The ID of the organizational unit.
         * </p>
         * 
         * @param organizationalUnitIds
         *        The ID of the organizational unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitIds(Collection<String> organizationalUnitIds);

        /**
         * <p>
         * The ID of the organizational unit.
         * </p>
         * 
         * @param organizationalUnitIds
         *        The ID of the organizational unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitIds(String... organizationalUnitIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DevOpsGuruRequest.BuilderImpl implements Builder {
        private Instant fromTime;

        private Instant toTime;

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> organizationalUnitIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationOverviewRequest model) {
            super(model);
            fromTime(model.fromTime);
            toTime(model.toTime);
            accountIds(model.accountIds);
            organizationalUnitIds(model.organizationalUnitIds);
        }

        public final Instant getFromTime() {
            return fromTime;
        }

        public final void setFromTime(Instant fromTime) {
            this.fromTime = fromTime;
        }

        @Override
        public final Builder fromTime(Instant fromTime) {
            this.fromTime = fromTime;
            return this;
        }

        public final Instant getToTime() {
            return toTime;
        }

        public final void setToTime(Instant toTime) {
            this.toTime = toTime;
        }

        @Override
        public final Builder toTime(Instant toTime) {
            this.toTime = toTime;
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getOrganizationalUnitIds() {
            if (organizationalUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnitIds;
        }

        public final void setOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
        }

        @Override
        public final Builder organizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitIds(String... organizationalUnitIds) {
            organizationalUnitIds(Arrays.asList(organizationalUnitIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOrganizationOverviewRequest build() {
            return new DescribeOrganizationOverviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
