/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.devopsguru.model.AccessDeniedException;
import software.amazon.awssdk.services.devopsguru.model.AddNotificationChannelRequest;
import software.amazon.awssdk.services.devopsguru.model.AddNotificationChannelResponse;
import software.amazon.awssdk.services.devopsguru.model.ConflictException;
import software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.DeleteInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationResponse;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruException;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest;
import software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest;
import software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse;
import software.amazon.awssdk.services.devopsguru.model.InternalServerException;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListEventsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListEventsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest;
import software.amazon.awssdk.services.devopsguru.model.PutFeedbackResponse;
import software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest;
import software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelResponse;
import software.amazon.awssdk.services.devopsguru.model.ResourceNotFoundException;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest;
import software.amazon.awssdk.services.devopsguru.model.StartCostEstimationResponse;
import software.amazon.awssdk.services.devopsguru.model.ThrottlingException;
import software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigResponse;
import software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionResponse;
import software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest;
import software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationResponse;
import software.amazon.awssdk.services.devopsguru.model.ValidationException;
import software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthIterable;
import software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthIterable;
import software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationIterable;
import software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListEventsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListInsightsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsIterable;
import software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsIterable;

/**
 * Service client for accessing Amazon DevOps Guru. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon DevOps Guru is a fully managed service that helps you identify anomalous behavior in business critical
 * operational applications. You specify the Amazon Web Services resources that you want DevOps Guru to cover, then the
 * Amazon CloudWatch metrics and Amazon Web Services CloudTrail events related to those resources are analyzed. When
 * anomalous behavior is detected, DevOps Guru creates an <i>insight</i> that includes recommendations, related events,
 * and related metrics that can help you improve your operational applications. For more information, see <a
 * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html">What is Amazon DevOps Guru</a>.
 * </p>
 * <p>
 * You can specify 1 or 2 Amazon Simple Notification Service topics so you are notified every time a new insight is
 * created. You can also enable DevOps Guru to generate an OpsItem in Amazon Web Services Systems Manager for each
 * insight to help you manage and track your work addressing insights.
 * </p>
 * <p>
 * To learn about the DevOps Guru workflow, see <a
 * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html#how-it-works">How DevOps Guru works</a>.
 * To learn about DevOps Guru concepts, see <a
 * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/concepts.html">Concepts in DevOps Guru</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DevOpsGuruClient extends AwsClient {
    String SERVICE_NAME = "devops-guru";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "devops-guru";

    /**
     * <p>
     * Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps
     * Guru events, such as when an insight is generated.
     * </p>
     * <p>
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
     * permission to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications
     * using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for
     * Amazon SNS topics</a>.
     * </p>
     * <p>
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service
     * customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon
     * Web Services KMS–encrypted Amazon SNS topics</a>.
     * </p>
     *
     * @param addNotificationChannelRequest
     * @return Result of the AddNotificationChannel operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ServiceQuotaExceededException
     *         The request contains a value that exceeds a maximum quota.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.AddNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default AddNotificationChannelResponse addNotificationChannel(AddNotificationChannelRequest addNotificationChannelRequest)
            throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps
     * Guru events, such as when an insight is generated.
     * </p>
     * <p>
     * If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru
     * permission to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications
     * using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for
     * Amazon SNS topics</a>.
     * </p>
     * <p>
     * If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service
     * customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a
     * href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon
     * Web Services KMS–encrypted Amazon SNS topics</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddNotificationChannelRequest.Builder} avoiding the
     * need to create one manually via {@link AddNotificationChannelRequest#builder()}
     * </p>
     *
     * @param addNotificationChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.AddNotificationChannelRequest.Builder} to create a
     *        request.
     * @return Result of the AddNotificationChannel operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ServiceQuotaExceededException
     *         The request contains a value that exceeds a maximum quota.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.AddNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default AddNotificationChannelResponse addNotificationChannel(
            Consumer<AddNotificationChannelRequest.Builder> addNotificationChannelRequest) throws AccessDeniedException,
            ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return addNotificationChannel(AddNotificationChannelRequest.builder().applyMutation(addNotificationChannelRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the insight along with the associated anomalies, events and recommendations.
     * </p>
     *
     * @param deleteInsightRequest
     * @return Result of the DeleteInsight operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInsightResponse deleteInsight(DeleteInsightRequest deleteInsightRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the insight along with the associated anomalies, events and recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInsightRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInsightRequest#builder()}
     * </p>
     *
     * @param deleteInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest.Builder} to create a request.
     * @return Result of the DeleteInsight operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInsightResponse deleteInsight(Consumer<DeleteInsightRequest.Builder> deleteInsightRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ConflictException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return deleteInsight(DeleteInsightRequest.builder().applyMutation(deleteInsightRequest).build());
    }

    /**
     * <p>
     * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics
     * analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon
     * Web Services account.
     * </p>
     *
     * @param describeAccountHealthRequest
     * @return Result of the DescribeAccountHealth operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeAccountHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountHealthResponse describeAccountHealth(DescribeAccountHealthRequest describeAccountHealthRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics
     * analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon
     * Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountHealthRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAccountHealthRequest#builder()}
     * </p>
     *
     * @param describeAccountHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAccountHealth operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeAccountHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountHealthResponse describeAccountHealth(
            Consumer<DescribeAccountHealthRequest.Builder> describeAccountHealthRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return describeAccountHealth(DescribeAccountHealthRequest.builder().applyMutation(describeAccountHealthRequest).build());
    }

    /**
     * <p>
     * For the time range passed in, returns the number of open reactive insight that were created, the number of open
     * proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
     * </p>
     *
     * @param describeAccountOverviewRequest
     * @return Result of the DescribeAccountOverview operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeAccountOverview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountOverviewResponse describeAccountOverview(DescribeAccountOverviewRequest describeAccountOverviewRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For the time range passed in, returns the number of open reactive insight that were created, the number of open
     * proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountOverviewRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountOverviewRequest#builder()}
     * </p>
     *
     * @param describeAccountOverviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeAccountOverview operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeAccountOverview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountOverviewResponse describeAccountOverview(
            Consumer<DescribeAccountOverviewRequest.Builder> describeAccountOverviewRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return describeAccountOverview(DescribeAccountOverviewRequest.builder().applyMutation(describeAccountOverviewRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about an anomaly that you specify using its ID.
     * </p>
     *
     * @param describeAnomalyRequest
     * @return Result of the DescribeAnomaly operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeAnomaly
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAnomalyResponse describeAnomaly(DescribeAnomalyRequest describeAnomalyRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an anomaly that you specify using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnomalyRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAnomalyRequest#builder()}
     * </p>
     *
     * @param describeAnomalyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAnomaly operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeAnomaly
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAnomalyResponse describeAnomaly(Consumer<DescribeAnomalyRequest.Builder> describeAnomalyRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return describeAnomaly(DescribeAnomalyRequest.builder().applyMutation(describeAnomalyRequest).build());
    }

    /**
     * <p>
     * Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The
     * one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive
     * recommendations which can be stored and viewed in DevOps Guru.
     * </p>
     *
     * @param describeEventSourcesConfigRequest
     * @return Result of the DescribeEventSourcesConfig operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeEventSourcesConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeEventSourcesConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSourcesConfigResponse describeEventSourcesConfig(
            DescribeEventSourcesConfigRequest describeEventSourcesConfigRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the integration status of services that are integrated with DevOps Guru as Consumer via EventBridge. The
     * one service that can be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive
     * recommendations which can be stored and viewed in DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSourcesConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSourcesConfigRequest#builder()}
     * </p>
     *
     * @param describeEventSourcesConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEventSourcesConfig operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeEventSourcesConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeEventSourcesConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSourcesConfigResponse describeEventSourcesConfig(
            Consumer<DescribeEventSourcesConfigRequest.Builder> describeEventSourcesConfigRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return describeEventSourcesConfig(DescribeEventSourcesConfigRequest.builder()
                .applyMutation(describeEventSourcesConfigRequest).build());
    }

    /**
     * <p>
     * Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
     * </p>
     *
     * @param describeFeedbackRequest
     * @return Result of the DescribeFeedback operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFeedbackResponse describeFeedback(DescribeFeedbackRequest describeFeedbackRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the most recent feedback submitted in the current Amazon Web Services account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFeedbackRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFeedbackRequest#builder()}
     * </p>
     *
     * @param describeFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeFeedback operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeFeedback" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFeedbackResponse describeFeedback(Consumer<DescribeFeedbackRequest.Builder> describeFeedbackRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return describeFeedback(DescribeFeedbackRequest.builder().applyMutation(describeFeedbackRequest).build());
    }

    /**
     * <p>
     * Returns details about an insight that you specify using its ID.
     * </p>
     *
     * @param describeInsightRequest
     * @return Result of the DescribeInsight operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInsightResponse describeInsight(DescribeInsightRequest describeInsightRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an insight that you specify using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInsightRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInsightRequest#builder()}
     * </p>
     *
     * @param describeInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeInsight operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInsightResponse describeInsight(Consumer<DescribeInsightRequest.Builder> describeInsightRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return describeInsight(DescribeInsightRequest.builder().applyMutation(describeInsightRequest).build());
    }

    /**
     * <p>
     * Returns active insights, predictive insights, and resource hours analyzed in last hour.
     * </p>
     *
     * @param describeOrganizationHealthRequest
     * @return Result of the DescribeOrganizationHealth operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeOrganizationHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationHealthResponse describeOrganizationHealth(
            DescribeOrganizationHealthRequest describeOrganizationHealthRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns active insights, predictive insights, and resource hours analyzed in last hour.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationHealthRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOrganizationHealthRequest#builder()}
     * </p>
     *
     * @param describeOrganizationHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeOrganizationHealth operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeOrganizationHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationHealthResponse describeOrganizationHealth(
            Consumer<DescribeOrganizationHealthRequest.Builder> describeOrganizationHealthRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return describeOrganizationHealth(DescribeOrganizationHealthRequest.builder()
                .applyMutation(describeOrganizationHealthRequest).build());
    }

    /**
     * <p>
     * Returns an overview of your organization's history based on the specified time range. The overview includes the
     * total reactive and proactive insights.
     * </p>
     *
     * @param describeOrganizationOverviewRequest
     * @return Result of the DescribeOrganizationOverview operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeOrganizationOverview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationOverview"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationOverviewResponse describeOrganizationOverview(
            DescribeOrganizationOverviewRequest describeOrganizationOverviewRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an overview of your organization's history based on the specified time range. The overview includes the
     * total reactive and proactive insights.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationOverviewRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationOverviewRequest#builder()}
     * </p>
     *
     * @param describeOrganizationOverviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeOrganizationOverview operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeOrganizationOverview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationOverview"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationOverviewResponse describeOrganizationOverview(
            Consumer<DescribeOrganizationOverviewRequest.Builder> describeOrganizationOverviewRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return describeOrganizationOverview(DescribeOrganizationOverviewRequest.builder()
                .applyMutation(describeOrganizationOverviewRequest).build());
    }

    /**
     * <p>
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you
     * can filter those accounts using the <code>AccountIds</code> field.
     * </p>
     *
     * @param describeOrganizationResourceCollectionHealthRequest
     * @return Result of the DescribeOrganizationResourceCollectionHealth operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeOrganizationResourceCollectionHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationResourceCollectionHealthResponse describeOrganizationResourceCollectionHealth(
            DescribeOrganizationResourceCollectionHealthRequest describeOrganizationResourceCollectionHealthRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides an overview of your system's health. If additional member accounts are part of your organization, you
     * can filter those accounts using the <code>AccountIds</code> field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationResourceCollectionHealthRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationResourceCollectionHealthRequest#builder()}
     * </p>
     *
     * @param describeOrganizationResourceCollectionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeOrganizationResourceCollectionHealth operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeOrganizationResourceCollectionHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationResourceCollectionHealthResponse describeOrganizationResourceCollectionHealth(
            Consumer<DescribeOrganizationResourceCollectionHealthRequest.Builder> describeOrganizationResourceCollectionHealthRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return describeOrganizationResourceCollectionHealth(DescribeOrganizationResourceCollectionHealthRequest.builder()
                .applyMutation(describeOrganizationResourceCollectionHealthRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthIterable responses = client.describeOrganizationResourceCollectionHealthPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthIterable responses = client
     *             .describeOrganizationResourceCollectionHealthPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthIterable responses = client.describeOrganizationResourceCollectionHealthPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationResourceCollectionHealthRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeOrganizationResourceCollectionHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationResourceCollectionHealthIterable describeOrganizationResourceCollectionHealthPaginator(
            DescribeOrganizationResourceCollectionHealthRequest describeOrganizationResourceCollectionHealthRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return new DescribeOrganizationResourceCollectionHealthIterable(this, describeOrganizationResourceCollectionHealthRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrganizationResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthIterable responses = client.describeOrganizationResourceCollectionHealthPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthIterable responses = client
     *             .describeOrganizationResourceCollectionHealthPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeOrganizationResourceCollectionHealthIterable responses = client.describeOrganizationResourceCollectionHealthPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationResourceCollectionHealthRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationResourceCollectionHealthRequest#builder()}
     * </p>
     *
     * @param describeOrganizationResourceCollectionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeOrganizationResourceCollectionHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeOrganizationResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationResourceCollectionHealthIterable describeOrganizationResourceCollectionHealthPaginator(
            Consumer<DescribeOrganizationResourceCollectionHealthRequest.Builder> describeOrganizationResourceCollectionHealthRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return describeOrganizationResourceCollectionHealthPaginator(DescribeOrganizationResourceCollectionHealthRequest
                .builder().applyMutation(describeOrganizationResourceCollectionHealthRequest).build());
    }

    /**
     * <p>
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for
     * all closed insights in resource collections in your account. You specify the type of Amazon Web Services
     * resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     *
     * @param describeResourceCollectionHealthRequest
     * @return Result of the DescribeResourceCollectionHealth operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeResourceCollectionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceCollectionHealthResponse describeResourceCollectionHealth(
            DescribeResourceCollectionHealthRequest describeResourceCollectionHealthRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for
     * all closed insights in resource collections in your account. You specify the type of Amazon Web Services
     * resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceCollectionHealthRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeResourceCollectionHealthRequest#builder()}
     * </p>
     *
     * @param describeResourceCollectionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeResourceCollectionHealth operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeResourceCollectionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceCollectionHealthResponse describeResourceCollectionHealth(
            Consumer<DescribeResourceCollectionHealthRequest.Builder> describeResourceCollectionHealthRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return describeResourceCollectionHealth(DescribeResourceCollectionHealthRequest.builder()
                .applyMutation(describeResourceCollectionHealthRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthIterable responses = client.describeResourceCollectionHealthPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthIterable responses = client
     *             .describeResourceCollectionHealthPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthIterable responses = client.describeResourceCollectionHealthPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeResourceCollectionHealthRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeResourceCollectionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceCollectionHealthIterable describeResourceCollectionHealthPaginator(
            DescribeResourceCollectionHealthRequest describeResourceCollectionHealthRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return new DescribeResourceCollectionHealthIterable(this, describeResourceCollectionHealthRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthIterable responses = client.describeResourceCollectionHealthPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthIterable responses = client
     *             .describeResourceCollectionHealthPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.DescribeResourceCollectionHealthIterable responses = client.describeResourceCollectionHealthPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeResourceCollectionHealth(software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceCollectionHealthRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeResourceCollectionHealthRequest#builder()}
     * </p>
     *
     * @param describeResourceCollectionHealthRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeResourceCollectionHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceCollectionHealthIterable describeResourceCollectionHealthPaginator(
            Consumer<DescribeResourceCollectionHealthRequest.Builder> describeResourceCollectionHealthRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return describeResourceCollectionHealthPaginator(DescribeResourceCollectionHealthRequest.builder()
                .applyMutation(describeResourceCollectionHealthRequest).build());
    }

    /**
     * <p>
     * Returns the integration status of services that are integrated with DevOps Guru. The one service that can be
     * integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for
     * each generated insight.
     * </p>
     *
     * @param describeServiceIntegrationRequest
     * @return Result of the DescribeServiceIntegration operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeServiceIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceIntegrationResponse describeServiceIntegration(
            DescribeServiceIntegrationRequest describeServiceIntegrationRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the integration status of services that are integrated with DevOps Guru. The one service that can be
     * integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for
     * each generated insight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceIntegrationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeServiceIntegrationRequest#builder()}
     * </p>
     *
     * @param describeServiceIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeServiceIntegration operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.DescribeServiceIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeServiceIntegrationResponse describeServiceIntegration(
            Consumer<DescribeServiceIntegrationRequest.Builder> describeServiceIntegrationRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return describeServiceIntegration(DescribeServiceIntegrationRequest.builder()
                .applyMutation(describeServiceIntegrationRequest).build());
    }

    /**
     * <p>
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more
     * information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate
     * your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru
     * pricing</a>.
     * </p>
     *
     * @param getCostEstimationRequest
     * @return Result of the GetCostEstimation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.GetCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCostEstimationResponse getCostEstimation(GetCostEstimationRequest getCostEstimationRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more
     * information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate
     * your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru
     * pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostEstimationRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostEstimationRequest#builder()}
     * </p>
     *
     * @param getCostEstimationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest.Builder} to create a
     *        request.
     * @return Result of the GetCostEstimation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.GetCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCostEstimationResponse getCostEstimation(Consumer<GetCostEstimationRequest.Builder> getCostEstimationRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return getCostEstimation(GetCostEstimationRequest.builder().applyMutation(getCostEstimationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCostEstimation(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationIterable responses = client.getCostEstimationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationIterable responses = client
     *             .getCostEstimationPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationIterable responses = client.getCostEstimationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCostEstimation(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCostEstimationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.GetCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCostEstimationIterable getCostEstimationPaginator(GetCostEstimationRequest getCostEstimationRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new GetCostEstimationIterable(this, getCostEstimationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCostEstimation(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationIterable responses = client.getCostEstimationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationIterable responses = client
     *             .getCostEstimationPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetCostEstimationIterable responses = client.getCostEstimationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCostEstimation(software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCostEstimationRequest.Builder} avoiding the need
     * to create one manually via {@link GetCostEstimationRequest#builder()}
     * </p>
     *
     * @param getCostEstimationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.GetCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetCostEstimation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCostEstimationIterable getCostEstimationPaginator(
            Consumer<GetCostEstimationRequest.Builder> getCostEstimationRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return getCostEstimationPaginator(GetCostEstimationRequest.builder().applyMutation(getCostEstimationRequest).build());
    }

    /**
     * <p>
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of
     * Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web
     * Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
     * Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>.
     * You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     *
     * @param getResourceCollectionRequest
     * @return Result of the GetResourceCollection operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.GetResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceCollectionResponse getResourceCollection(GetResourceCollectionRequest getResourceCollectionRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of
     * Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web
     * Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the
     * Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>.
     * You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceCollectionRequest#builder()}
     * </p>
     *
     * @param getResourceCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourceCollection operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.GetResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceCollectionResponse getResourceCollection(
            Consumer<GetResourceCollectionRequest.Builder> getResourceCollectionRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return getResourceCollection(GetResourceCollectionRequest.builder().applyMutation(getResourceCollectionRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourceCollection(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionIterable responses = client.getResourceCollectionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionIterable responses = client
     *             .getResourceCollectionPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionIterable responses = client.getResourceCollectionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceCollection(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceCollectionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.GetResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceCollectionIterable getResourceCollectionPaginator(GetResourceCollectionRequest getResourceCollectionRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new GetResourceCollectionIterable(this, getResourceCollectionRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourceCollection(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionIterable responses = client.getResourceCollectionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionIterable responses = client
     *             .getResourceCollectionPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.GetResourceCollectionIterable responses = client.getResourceCollectionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceCollection(software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceCollectionRequest#builder()}
     * </p>
     *
     * @param getResourceCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.GetResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceCollectionIterable getResourceCollectionPaginator(
            Consumer<GetResourceCollectionRequest.Builder> getResourceCollectionRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return getResourceCollectionPaginator(GetResourceCollectionRequest.builder().applyMutation(getResourceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     * </p>
     *
     * @param listAnomaliesForInsightRequest
     * @return Result of the ListAnomaliesForInsight operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListAnomaliesForInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomaliesForInsightResponse listAnomaliesForInsight(ListAnomaliesForInsightRequest listAnomaliesForInsightRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the anomalies that belong to an insight that you specify using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomaliesForInsightRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomaliesForInsightRequest#builder()}
     * </p>
     *
     * @param listAnomaliesForInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest.Builder} to create
     *        a request.
     * @return Result of the ListAnomaliesForInsight operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListAnomaliesForInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomaliesForInsightResponse listAnomaliesForInsight(
            Consumer<ListAnomaliesForInsightRequest.Builder> listAnomaliesForInsightRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return listAnomaliesForInsight(ListAnomaliesForInsightRequest.builder().applyMutation(listAnomaliesForInsightRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomaliesForInsight(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightIterable responses = client.listAnomaliesForInsightPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightIterable responses = client
     *             .listAnomaliesForInsightPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightIterable responses = client.listAnomaliesForInsightPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomaliesForInsight(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomaliesForInsightRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListAnomaliesForInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomaliesForInsightIterable listAnomaliesForInsightPaginator(
            ListAnomaliesForInsightRequest listAnomaliesForInsightRequest) throws AccessDeniedException, InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return new ListAnomaliesForInsightIterable(this, listAnomaliesForInsightRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomaliesForInsight(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightIterable responses = client.listAnomaliesForInsightPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightIterable responses = client
     *             .listAnomaliesForInsightPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomaliesForInsightIterable responses = client.listAnomaliesForInsightPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomaliesForInsight(software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomaliesForInsightRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnomaliesForInsightRequest#builder()}
     * </p>
     *
     * @param listAnomaliesForInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListAnomaliesForInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomaliesForInsightIterable listAnomaliesForInsightPaginator(
            Consumer<ListAnomaliesForInsightRequest.Builder> listAnomaliesForInsightRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return listAnomaliesForInsightPaginator(ListAnomaliesForInsightRequest.builder()
                .applyMutation(listAnomaliesForInsightRequest).build());
    }

    /**
     * <p>
     * Returns the list of log groups that contain log anomalies.
     * </p>
     *
     * @param listAnomalousLogGroupsRequest
     * @return Result of the ListAnomalousLogGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListAnomalousLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalousLogGroupsResponse listAnomalousLogGroups(ListAnomalousLogGroupsRequest listAnomalousLogGroupsRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of log groups that contain log anomalies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalousLogGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnomalousLogGroupsRequest#builder()}
     * </p>
     *
     * @param listAnomalousLogGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAnomalousLogGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListAnomalousLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalousLogGroupsResponse listAnomalousLogGroups(
            Consumer<ListAnomalousLogGroupsRequest.Builder> listAnomalousLogGroupsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return listAnomalousLogGroups(ListAnomalousLogGroupsRequest.builder().applyMutation(listAnomalousLogGroupsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalousLogGroups(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsIterable responses = client.listAnomalousLogGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsIterable responses = client
     *             .listAnomalousLogGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsIterable responses = client.listAnomalousLogGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalousLogGroups(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnomalousLogGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListAnomalousLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalousLogGroupsIterable listAnomalousLogGroupsPaginator(
            ListAnomalousLogGroupsRequest listAnomalousLogGroupsRequest) throws AccessDeniedException, InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return new ListAnomalousLogGroupsIterable(this, listAnomalousLogGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnomalousLogGroups(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsIterable responses = client.listAnomalousLogGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsIterable responses = client
     *             .listAnomalousLogGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListAnomalousLogGroupsIterable responses = client.listAnomalousLogGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnomalousLogGroups(software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnomalousLogGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnomalousLogGroupsRequest#builder()}
     * </p>
     *
     * @param listAnomalousLogGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListAnomalousLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomalousLogGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnomalousLogGroupsIterable listAnomalousLogGroupsPaginator(
            Consumer<ListAnomalousLogGroupsRequest.Builder> listAnomalousLogGroupsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return listAnomalousLogGroupsPaginator(ListAnomalousLogGroupsRequest.builder()
                .applyMutation(listAnomalousLogGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to
     * specify which events are returned.
     * </p>
     *
     * @param listEventsRequest
     * @return Result of the ListEvents operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventsResponse listEvents(ListEventsRequest listEventsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to
     * specify which events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventsRequest#builder()}
     * </p>
     *
     * @param listEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListEventsRequest.Builder} to create a request.
     * @return Result of the ListEvents operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventsResponse listEvents(Consumer<ListEventsRequest.Builder> listEventsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return listEvents(ListEventsRequest.builder().applyMutation(listEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listEvents(software.amazon.awssdk.services.devopsguru.model.ListEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvents(software.amazon.awssdk.services.devopsguru.model.ListEventsRequest)} operation.</b>
     * </p>
     *
     * @param listEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventsIterable listEventsPaginator(ListEventsRequest listEventsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return new ListEventsIterable(this, listEventsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listEvents(software.amazon.awssdk.services.devopsguru.model.ListEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListEventsIterable responses = client.listEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvents(software.amazon.awssdk.services.devopsguru.model.ListEventsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventsRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventsRequest#builder()}
     * </p>
     *
     * @param listEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListEventsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEventsIterable listEventsPaginator(Consumer<ListEventsRequest.Builder> listEventsRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return listEventsPaginator(ListEventsRequest.builder().applyMutation(listEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or <code>ANY</code>).
     * </p>
     *
     * @param listInsightsRequest
     * @return Result of the ListInsights operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInsightsResponse listInsights(ListInsightsRequest listInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or <code>ANY</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInsightsRequest#builder()}
     * </p>
     *
     * @param listInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest.Builder} to create a request.
     * @return Result of the ListInsights operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInsightsResponse listInsights(Consumer<ListInsightsRequest.Builder> listInsightsRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return listInsights(ListInsightsRequest.builder().applyMutation(listInsightsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listInsights(software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListInsightsIterable responses = client.listInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListInsightsIterable responses = client.listInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListInsightsIterable responses = client.listInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInsights(software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest)} operation.</b>
     * </p>
     *
     * @param listInsightsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInsightsIterable listInsightsPaginator(ListInsightsRequest listInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return new ListInsightsIterable(this, listInsightsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listInsights(software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListInsightsIterable responses = client.listInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListInsightsIterable responses = client.listInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListInsightsIterable responses = client.listInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInsights(software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInsightsRequest#builder()}
     * </p>
     *
     * @param listInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInsightsIterable listInsightsPaginator(Consumer<ListInsightsRequest.Builder> listInsightsRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return listInsightsPaginator(ListInsightsRequest.builder().applyMutation(listInsightsRequest).build());
    }

    /**
     * <p>
     * Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
     * </p>
     *
     * @param listMonitoredResourcesRequest
     * @return Result of the ListMonitoredResources operation returned by the service.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListMonitoredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitoredResourcesResponse listMonitoredResources(ListMonitoredResourcesRequest listMonitoredResourcesRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of all log groups that are being monitored and tagged by DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitoredResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListMonitoredResourcesRequest#builder()}
     * </p>
     *
     * @param listMonitoredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListMonitoredResources operation returned by the service.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListMonitoredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitoredResourcesResponse listMonitoredResources(
            Consumer<ListMonitoredResourcesRequest.Builder> listMonitoredResourcesRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return listMonitoredResources(ListMonitoredResourcesRequest.builder().applyMutation(listMonitoredResourcesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMonitoredResources(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesIterable responses = client.listMonitoredResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesIterable responses = client
     *             .listMonitoredResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesIterable responses = client.listMonitoredResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitoredResources(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMonitoredResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListMonitoredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitoredResourcesIterable listMonitoredResourcesPaginator(
            ListMonitoredResourcesRequest listMonitoredResourcesRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return new ListMonitoredResourcesIterable(this, listMonitoredResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMonitoredResources(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesIterable responses = client.listMonitoredResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesIterable responses = client
     *             .listMonitoredResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListMonitoredResourcesIterable responses = client.listMonitoredResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMonitoredResources(software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMonitoredResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListMonitoredResourcesRequest#builder()}
     * </p>
     *
     * @param listMonitoredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListMonitoredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListMonitoredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMonitoredResourcesIterable listMonitoredResourcesPaginator(
            Consumer<ListMonitoredResourcesRequest.Builder> listMonitoredResourcesRequest) throws ResourceNotFoundException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return listMonitoredResourcesPaginator(ListMonitoredResourcesRequest.builder()
                .applyMutation(listMonitoredResourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify
     * you when DevOps Guru generates an insight that contains information about how to improve your operations. The one
     * supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     * </p>
     *
     * @param listNotificationChannelsRequest
     * @return Result of the ListNotificationChannels operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationChannelsResponse listNotificationChannels(
            ListNotificationChannelsRequest listNotificationChannelsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify
     * you when DevOps Guru generates an insight that contains information about how to improve your operations. The one
     * supported notification channel is Amazon Simple Notification Service (Amazon SNS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationChannelsRequest.Builder} avoiding
     * the need to create one manually via {@link ListNotificationChannelsRequest#builder()}
     * </p>
     *
     * @param listNotificationChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest.Builder} to create
     *        a request.
     * @return Result of the ListNotificationChannels operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationChannelsResponse listNotificationChannels(
            Consumer<ListNotificationChannelsRequest.Builder> listNotificationChannelsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return listNotificationChannels(ListNotificationChannelsRequest.builder().applyMutation(listNotificationChannelsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationChannels(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsIterable responses = client.listNotificationChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsIterable responses = client
     *             .listNotificationChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsIterable responses = client.listNotificationChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationChannels(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationChannelsIterable listNotificationChannelsPaginator(
            ListNotificationChannelsRequest listNotificationChannelsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return new ListNotificationChannelsIterable(this, listNotificationChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationChannels(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsIterable responses = client.listNotificationChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsIterable responses = client
     *             .listNotificationChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListNotificationChannelsIterable responses = client.listNotificationChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationChannels(software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationChannelsRequest.Builder} avoiding
     * the need to create one manually via {@link ListNotificationChannelsRequest#builder()}
     * </p>
     *
     * @param listNotificationChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListNotificationChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationChannelsIterable listNotificationChannelsPaginator(
            Consumer<ListNotificationChannelsRequest.Builder> listNotificationChannelsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return listNotificationChannelsPaginator(ListNotificationChannelsRequest.builder()
                .applyMutation(listNotificationChannelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights associated with the account or OU Id.
     * </p>
     *
     * @param listOrganizationInsightsRequest
     * @return Result of the ListOrganizationInsights operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationInsightsResponse listOrganizationInsights(
            ListOrganizationInsightsRequest listOrganizationInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of insights associated with the account or OU Id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOrganizationInsightsRequest#builder()}
     * </p>
     *
     * @param listOrganizationInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest.Builder} to create
     *        a request.
     * @return Result of the ListOrganizationInsights operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationInsightsResponse listOrganizationInsights(
            Consumer<ListOrganizationInsightsRequest.Builder> listOrganizationInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return listOrganizationInsights(ListOrganizationInsightsRequest.builder().applyMutation(listOrganizationInsightsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsIterable responses = client.listOrganizationInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsIterable responses = client
     *             .listOrganizationInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsIterable responses = client.listOrganizationInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationInsightsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationInsightsIterable listOrganizationInsightsPaginator(
            ListOrganizationInsightsRequest listOrganizationInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return new ListOrganizationInsightsIterable(this, listOrganizationInsightsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsIterable responses = client.listOrganizationInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsIterable responses = client
     *             .listOrganizationInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListOrganizationInsightsIterable responses = client.listOrganizationInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOrganizationInsightsRequest#builder()}
     * </p>
     *
     * @param listOrganizationInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationInsightsIterable listOrganizationInsightsPaginator(
            Consumer<ListOrganizationInsightsRequest.Builder> listOrganizationInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return listOrganizationInsightsPaginator(ListOrganizationInsightsRequest.builder()
                .applyMutation(listOrganizationInsightsRequest).build());
    }

    /**
     * <p>
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics
     * and a list of related events.
     * </p>
     *
     * @param listRecommendationsRequest
     * @return Result of the ListRecommendations operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsResponse listRecommendations(ListRecommendationsRequest listRecommendationsRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of a specified insight's recommendations. Each recommendation includes a list of related metrics
     * and a list of related events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRecommendations operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsResponse listRecommendations(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return listRecommendations(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsIterable responses = client
     *             .listRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsIterable listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest)
            throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return new ListRecommendationsIterable(this, listRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsIterable responses = client
     *             .listRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.ListRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsIterable listRecommendationsPaginator(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) throws AccessDeniedException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return listRecommendationsPaginator(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Collects customer feedback about the specified insight.
     * </p>
     *
     * @param putFeedbackRequest
     * @return Result of the PutFeedback operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws AccessDeniedException,
            ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Collects customer feedback about the specified insight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFeedbackRequest.Builder} avoiding the need to
     * create one manually via {@link PutFeedbackRequest#builder()}
     * </p>
     *
     * @param putFeedbackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest.Builder} to create a request.
     * @return Result of the PutFeedback operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.PutFeedback
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback" target="_top">AWS API
     *      Documentation</a>
     */
    default PutFeedbackResponse putFeedback(Consumer<PutFeedbackRequest.Builder> putFeedbackRequest)
            throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        return putFeedback(PutFeedbackRequest.builder().applyMutation(putFeedbackRequest).build());
    }

    /**
     * <p>
     * Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru
     * generates an insight that contains information about how to improve your operations.
     * </p>
     *
     * @param removeNotificationChannelRequest
     * @return Result of the RemoveNotificationChannel operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.RemoveNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveNotificationChannelResponse removeNotificationChannel(
            RemoveNotificationChannelRequest removeNotificationChannelRequest) throws AccessDeniedException, ConflictException,
            InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru
     * generates an insight that contains information about how to improve your operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveNotificationChannelRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveNotificationChannelRequest#builder()}
     * </p>
     *
     * @param removeNotificationChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest.Builder} to
     *        create a request.
     * @return Result of the RemoveNotificationChannel operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.RemoveNotificationChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveNotificationChannelResponse removeNotificationChannel(
            Consumer<RemoveNotificationChannelRequest.Builder> removeNotificationChannelRequest) throws AccessDeniedException,
            ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DevOpsGuruException {
        return removeNotificationChannel(RemoveNotificationChannelRequest.builder()
                .applyMutation(removeNotificationChannelRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time, one or more statuses (<code>ONGOING</code> or <code>CLOSED</code>), one or more severities (
     * <code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     *
     * @param searchInsightsRequest
     * @return Result of the SearchInsights operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.SearchInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchInsightsResponse searchInsights(SearchInsightsRequest searchInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by
     * their start time, one or more statuses (<code>ONGOING</code> or <code>CLOSED</code>), one or more severities (
     * <code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchInsightsRequest#builder()}
     * </p>
     *
     * @param searchInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest.Builder} to create a
     *        request.
     * @return Result of the SearchInsights operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.SearchInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchInsightsResponse searchInsights(Consumer<SearchInsightsRequest.Builder> searchInsightsRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return searchInsights(SearchInsightsRequest.builder().applyMutation(searchInsightsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchInsights(software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsIterable responses = client.searchInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsIterable responses = client
     *             .searchInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsIterable responses = client.searchInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchInsights(software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest)} operation.</b>
     * </p>
     *
     * @param searchInsightsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.SearchInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchInsightsIterable searchInsightsPaginator(SearchInsightsRequest searchInsightsRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return new SearchInsightsIterable(this, searchInsightsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchInsights(software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsIterable responses = client.searchInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsIterable responses = client
     *             .searchInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchInsightsIterable responses = client.searchInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchInsights(software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchInsightsRequest#builder()}
     * </p>
     *
     * @param searchInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.SearchInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchInsightsIterable searchInsightsPaginator(Consumer<SearchInsightsRequest.Builder> searchInsightsRequest)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return searchInsightsPaginator(SearchInsightsRequest.builder().applyMutation(searchInsightsRequest).build());
    }

    /**
     * <p>
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time,
     * one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities
     * (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     *
     * @param searchOrganizationInsightsRequest
     * @return Result of the SearchOrganizationInsights operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.SearchOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchOrganizationInsightsResponse searchOrganizationInsights(
            SearchOrganizationInsightsRequest searchOrganizationInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of insights in your organization. You can specify which insights are returned by their start time,
     * one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities
     * (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or
     * <code>PROACTIVE</code>).
     * </p>
     * <p>
     * Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the
     * <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchOrganizationInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchOrganizationInsightsRequest#builder()}
     * </p>
     *
     * @param searchOrganizationInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest.Builder} to
     *        create a request.
     * @return Result of the SearchOrganizationInsights operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.SearchOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchOrganizationInsightsResponse searchOrganizationInsights(
            Consumer<SearchOrganizationInsightsRequest.Builder> searchOrganizationInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return searchOrganizationInsights(SearchOrganizationInsightsRequest.builder()
                .applyMutation(searchOrganizationInsightsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsIterable responses = client.searchOrganizationInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsIterable responses = client
     *             .searchOrganizationInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsIterable responses = client.searchOrganizationInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchOrganizationInsightsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.SearchOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchOrganizationInsightsIterable searchOrganizationInsightsPaginator(
            SearchOrganizationInsightsRequest searchOrganizationInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return new SearchOrganizationInsightsIterable(this, searchOrganizationInsightsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #searchOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsIterable responses = client.searchOrganizationInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsIterable responses = client
     *             .searchOrganizationInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.devopsguru.paginators.SearchOrganizationInsightsIterable responses = client.searchOrganizationInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchOrganizationInsights(software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchOrganizationInsightsRequest.Builder} avoiding
     * the need to create one manually via {@link SearchOrganizationInsightsRequest#builder()}
     * </p>
     *
     * @param searchOrganizationInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.SearchOrganizationInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchOrganizationInsights"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchOrganizationInsightsIterable searchOrganizationInsightsPaginator(
            Consumer<SearchOrganizationInsightsRequest.Builder> searchOrganizationInsightsRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return searchOrganizationInsightsPaginator(SearchOrganizationInsightsRequest.builder()
                .applyMutation(searchOrganizationInsightsRequest).build());
    }

    /**
     * <p>
     * Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
     * </p>
     *
     * @param startCostEstimationRequest
     * @return Result of the StartCostEstimation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.StartCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/StartCostEstimation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCostEstimationResponse startCostEstimation(StartCostEstimationRequest startCostEstimationRequest)
            throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException,
            ThrottlingException, ValidationException, AwsServiceException, SdkClientException, DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCostEstimationRequest.Builder} avoiding the
     * need to create one manually via {@link StartCostEstimationRequest#builder()}
     * </p>
     *
     * @param startCostEstimationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest.Builder} to create a
     *        request.
     * @return Result of the StartCostEstimation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ResourceNotFoundException
     *         A requested resource could not be found
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.StartCostEstimation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/StartCostEstimation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartCostEstimationResponse startCostEstimation(
            Consumer<StartCostEstimationRequest.Builder> startCostEstimationRequest) throws AccessDeniedException,
            ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, DevOpsGuruException {
        return startCostEstimation(StartCostEstimationRequest.builder().applyMutation(startCostEstimationRequest).build());
    }

    /**
     * <p>
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can
     * be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can
     * be stored and viewed in DevOps Guru.
     * </p>
     *
     * @param updateEventSourcesConfigRequest
     * @return Result of the UpdateEventSourcesConfig operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.UpdateEventSourcesConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateEventSourcesConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventSourcesConfigResponse updateEventSourcesConfig(
            UpdateEventSourcesConfigRequest updateEventSourcesConfigRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can
     * be integrated with DevOps Guru is Amazon CodeGuru Profiler, which can produce proactive recommendations which can
     * be stored and viewed in DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventSourcesConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEventSourcesConfigRequest#builder()}
     * </p>
     *
     * @param updateEventSourcesConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateEventSourcesConfig operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.UpdateEventSourcesConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateEventSourcesConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventSourcesConfigResponse updateEventSourcesConfig(
            Consumer<UpdateEventSourcesConfigRequest.Builder> updateEventSourcesConfigRequest) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        return updateEventSourcesConfig(UpdateEventSourcesConfigRequest.builder().applyMutation(updateEventSourcesConfigRequest)
                .build());
    }

    /**
     * <p>
     * Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource
     * collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that
     * contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
     * resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to
     * 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use
     * DevOps Guru.
     * </p>
     *
     * @param updateResourceCollectionRequest
     * @return Result of the UpdateResourceCollection operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.UpdateResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceCollectionResponse updateResourceCollection(
            UpdateResourceCollectionRequest updateResourceCollectionRequest) throws AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource
     * collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that
     * contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services
     * resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to
     * 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use
     * DevOps Guru.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceCollectionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateResourceCollectionRequest#builder()}
     * </p>
     *
     * @param updateResourceCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateResourceCollection operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.UpdateResourceCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceCollectionResponse updateResourceCollection(
            Consumer<UpdateResourceCollectionRequest.Builder> updateResourceCollectionRequest) throws AccessDeniedException,
            ConflictException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return updateResourceCollection(UpdateResourceCollectionRequest.builder().applyMutation(updateResourceCollectionRequest)
                .build());
    }

    /**
     * <p>
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can
     * be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for
     * each generated insight.
     * </p>
     *
     * @param updateServiceIntegrationRequest
     * @return Result of the UpdateServiceIntegration operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.UpdateServiceIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceIntegrationResponse updateServiceIntegration(
            UpdateServiceIntegrationRequest updateServiceIntegrationRequest) throws AccessDeniedException, ConflictException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            DevOpsGuruException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can
     * be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for
     * each generated insight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceIntegrationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateServiceIntegrationRequest#builder()}
     * </p>
     *
     * @param updateServiceIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateServiceIntegration operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permissions to perform the requested operation. The user or role that is making the
     *         request must have at least one IAM permissions policy attached that grants the required permissions. For
     *         more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     *         Management</a> in the <i>IAM User Guide</i>.
     * @throws ConflictException
     *         An exception that is thrown when a conflict occurs.
     * @throws InternalServerException
     *         An internal failure in an Amazon service occurred.
     * @throws ThrottlingException
     *         The request was denied due to a request throttling.
     * @throws ValidationException
     *         Contains information about data passed in to a field during a request that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DevOpsGuruException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DevOpsGuruClient.UpdateServiceIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceIntegrationResponse updateServiceIntegration(
            Consumer<UpdateServiceIntegrationRequest.Builder> updateServiceIntegrationRequest) throws AccessDeniedException,
            ConflictException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, DevOpsGuruException {
        return updateServiceIntegration(UpdateServiceIntegrationRequest.builder().applyMutation(updateServiceIntegrationRequest)
                .build());
    }

    /**
     * Create a {@link DevOpsGuruClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DevOpsGuruClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DevOpsGuruClient}.
     */
    static DevOpsGuruClientBuilder builder() {
        return new DefaultDevOpsGuruClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default DevOpsGuruServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
