/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruRequest;
import software.amazon.awssdk.services.devopsguru.model.InsightType;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsFilters;
import software.amazon.awssdk.services.devopsguru.model.StartTimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchInsightsRequest
extends DevOpsGuruRequest
implements ToCopyableBuilder<Builder, SearchInsightsRequest> {
    private static final SdkField<StartTimeRange> START_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartTimeRange").getter(SearchInsightsRequest.getter(SearchInsightsRequest::startTimeRange)).setter(SearchInsightsRequest.setter(Builder::startTimeRange)).constructor(StartTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeRange").build()}).build();
    private static final SdkField<SearchInsightsFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(SearchInsightsRequest.getter(SearchInsightsRequest::filters)).setter(SearchInsightsRequest.setter(Builder::filters)).constructor(SearchInsightsFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchInsightsRequest.getter(SearchInsightsRequest::maxResults)).setter(SearchInsightsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchInsightsRequest.getter(SearchInsightsRequest::nextToken)).setter(SearchInsightsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SearchInsightsRequest.getter(SearchInsightsRequest::typeAsString)).setter(SearchInsightsRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_RANGE_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchInsightsRequest.memberNameToFieldInitializer();
    private final StartTimeRange startTimeRange;
    private final SearchInsightsFilters filters;
    private final Integer maxResults;
    private final String nextToken;
    private final String type;

    private SearchInsightsRequest(BuilderImpl builder) {
        super(builder);
        this.startTimeRange = builder.startTimeRange;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.type = builder.type;
    }

    public final StartTimeRange startTimeRange() {
        return this.startTimeRange;
    }

    public final SearchInsightsFilters filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final InsightType type() {
        return InsightType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchInsightsRequest)) {
            return false;
        }
        SearchInsightsRequest other = (SearchInsightsRequest)((Object)obj);
        return Objects.equals(this.startTimeRange(), other.startTimeRange()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchInsightsRequest").add("StartTimeRange", (Object)this.startTimeRange()).add("Filters", (Object)this.filters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTimeRange": {
                return Optional.ofNullable(clazz.cast(this.startTimeRange()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StartTimeRange", START_TIME_RANGE_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchInsightsRequest, T> g) {
        return obj -> g.apply((SearchInsightsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruRequest.BuilderImpl
    implements Builder {
        private StartTimeRange startTimeRange;
        private SearchInsightsFilters filters;
        private Integer maxResults;
        private String nextToken;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchInsightsRequest model) {
            super(model);
            this.startTimeRange(model.startTimeRange);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.type(model.type);
        }

        public final StartTimeRange.Builder getStartTimeRange() {
            return this.startTimeRange != null ? this.startTimeRange.toBuilder() : null;
        }

        public final void setStartTimeRange(StartTimeRange.BuilderImpl startTimeRange) {
            this.startTimeRange = startTimeRange != null ? startTimeRange.build() : null;
        }

        @Override
        public final Builder startTimeRange(StartTimeRange startTimeRange) {
            this.startTimeRange = startTimeRange;
            return this;
        }

        public final SearchInsightsFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(SearchInsightsFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchInsightsFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InsightType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchInsightsRequest build() {
            return new SearchInsightsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DevOpsGuruRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchInsightsRequest> {
        public Builder startTimeRange(StartTimeRange var1);

        default public Builder startTimeRange(Consumer<StartTimeRange.Builder> startTimeRange) {
            return this.startTimeRange((StartTimeRange)((StartTimeRange.Builder)StartTimeRange.builder().applyMutation(startTimeRange)).build());
        }

        public Builder filters(SearchInsightsFilters var1);

        default public Builder filters(Consumer<SearchInsightsFilters.Builder> filters) {
            return this.filters((SearchInsightsFilters)((SearchInsightsFilters.Builder)SearchInsightsFilters.builder().applyMutation(filters)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder type(String var1);

        public Builder type(InsightType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

