/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse;
import software.amazon.awssdk.services.devopsguru.model.NotificationChannel;

public class ListNotificationChannelsIterable
implements SdkIterable<ListNotificationChannelsResponse> {
    private final DevOpsGuruClient client;
    private final ListNotificationChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNotificationChannelsIterable(DevOpsGuruClient client, ListNotificationChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNotificationChannelsResponseFetcher();
    }

    public Iterator<ListNotificationChannelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NotificationChannel> channels() {
        Function<ListNotificationChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channels() != null) {
                return response.channels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNotificationChannelsResponseFetcher
    implements SyncPageFetcher<ListNotificationChannelsResponse> {
        private ListNotificationChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNotificationChannelsResponse nextPage(ListNotificationChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationChannelsIterable.this.client.listNotificationChannels(ListNotificationChannelsIterable.this.firstRequest);
            }
            return ListNotificationChannelsIterable.this.client.listNotificationChannels((ListNotificationChannelsRequest)((Object)ListNotificationChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

