/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.InsightSeverity;
import software.amazon.awssdk.services.devopsguru.model.InsightStatus;
import software.amazon.awssdk.services.devopsguru.model.InsightTimeRange;
import software.amazon.awssdk.services.devopsguru.model.PredictionTimeRange;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProactiveInsight
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProactiveInsight> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProactiveInsight.getter(ProactiveInsight::id)).setter(ProactiveInsight.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProactiveInsight.getter(ProactiveInsight::name)).setter(ProactiveInsight.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ProactiveInsight.getter(ProactiveInsight::severityAsString)).setter(ProactiveInsight.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProactiveInsight.getter(ProactiveInsight::statusAsString)).setter(ProactiveInsight.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<InsightTimeRange> INSIGHT_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InsightTimeRange").getter(ProactiveInsight.getter(ProactiveInsight::insightTimeRange)).setter(ProactiveInsight.setter(Builder::insightTimeRange)).constructor(InsightTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightTimeRange").build()}).build();
    private static final SdkField<PredictionTimeRange> PREDICTION_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredictionTimeRange").getter(ProactiveInsight.getter(ProactiveInsight::predictionTimeRange)).setter(ProactiveInsight.setter(Builder::predictionTimeRange)).constructor(PredictionTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionTimeRange").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(ProactiveInsight.getter(ProactiveInsight::resourceCollection)).setter(ProactiveInsight.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<String> SSM_OPS_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SsmOpsItemId").getter(ProactiveInsight.getter(ProactiveInsight::ssmOpsItemId)).setter(ProactiveInsight.setter(Builder::ssmOpsItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SsmOpsItemId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ProactiveInsight.getter(ProactiveInsight::description)).setter(ProactiveInsight.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, SEVERITY_FIELD, STATUS_FIELD, INSIGHT_TIME_RANGE_FIELD, PREDICTION_TIME_RANGE_FIELD, RESOURCE_COLLECTION_FIELD, SSM_OPS_ITEM_ID_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Severity", SEVERITY_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("InsightTimeRange", INSIGHT_TIME_RANGE_FIELD);
            this.put("PredictionTimeRange", PREDICTION_TIME_RANGE_FIELD);
            this.put("ResourceCollection", RESOURCE_COLLECTION_FIELD);
            this.put("SsmOpsItemId", SSM_OPS_ITEM_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String severity;
    private final String status;
    private final InsightTimeRange insightTimeRange;
    private final PredictionTimeRange predictionTimeRange;
    private final ResourceCollection resourceCollection;
    private final String ssmOpsItemId;
    private final String description;

    private ProactiveInsight(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.severity = builder.severity;
        this.status = builder.status;
        this.insightTimeRange = builder.insightTimeRange;
        this.predictionTimeRange = builder.predictionTimeRange;
        this.resourceCollection = builder.resourceCollection;
        this.ssmOpsItemId = builder.ssmOpsItemId;
        this.description = builder.description;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final InsightSeverity severity() {
        return InsightSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final InsightStatus status() {
        return InsightStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final InsightTimeRange insightTimeRange() {
        return this.insightTimeRange;
    }

    public final PredictionTimeRange predictionTimeRange() {
        return this.predictionTimeRange;
    }

    public final ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public final String ssmOpsItemId() {
        return this.ssmOpsItemId;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmOpsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProactiveInsight)) {
            return false;
        }
        ProactiveInsight other = (ProactiveInsight)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.insightTimeRange(), other.insightTimeRange()) && Objects.equals(this.predictionTimeRange(), other.predictionTimeRange()) && Objects.equals(this.resourceCollection(), other.resourceCollection()) && Objects.equals(this.ssmOpsItemId(), other.ssmOpsItemId()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ProactiveInsight").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).add("InsightTimeRange", (Object)this.insightTimeRange()).add("PredictionTimeRange", (Object)this.predictionTimeRange()).add("ResourceCollection", (Object)this.resourceCollection()).add("SsmOpsItemId", (Object)this.ssmOpsItemId()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "InsightTimeRange": {
                return Optional.ofNullable(clazz.cast(this.insightTimeRange()));
            }
            case "PredictionTimeRange": {
                return Optional.ofNullable(clazz.cast(this.predictionTimeRange()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "SsmOpsItemId": {
                return Optional.ofNullable(clazz.cast(this.ssmOpsItemId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProactiveInsight, T> g) {
        return obj -> g.apply((ProactiveInsight)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String severity;
        private String status;
        private InsightTimeRange insightTimeRange;
        private PredictionTimeRange predictionTimeRange;
        private ResourceCollection resourceCollection;
        private String ssmOpsItemId;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ProactiveInsight model) {
            this.id(model.id);
            this.name(model.name);
            this.severity(model.severity);
            this.status(model.status);
            this.insightTimeRange(model.insightTimeRange);
            this.predictionTimeRange(model.predictionTimeRange);
            this.resourceCollection(model.resourceCollection);
            this.ssmOpsItemId(model.ssmOpsItemId);
            this.description(model.description);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(InsightSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InsightStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final InsightTimeRange.Builder getInsightTimeRange() {
            return this.insightTimeRange != null ? this.insightTimeRange.toBuilder() : null;
        }

        public final void setInsightTimeRange(InsightTimeRange.BuilderImpl insightTimeRange) {
            this.insightTimeRange = insightTimeRange != null ? insightTimeRange.build() : null;
        }

        @Override
        public final Builder insightTimeRange(InsightTimeRange insightTimeRange) {
            this.insightTimeRange = insightTimeRange;
            return this;
        }

        public final PredictionTimeRange.Builder getPredictionTimeRange() {
            return this.predictionTimeRange != null ? this.predictionTimeRange.toBuilder() : null;
        }

        public final void setPredictionTimeRange(PredictionTimeRange.BuilderImpl predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange != null ? predictionTimeRange.build() : null;
        }

        @Override
        public final Builder predictionTimeRange(PredictionTimeRange predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange;
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final String getSsmOpsItemId() {
            return this.ssmOpsItemId;
        }

        public final void setSsmOpsItemId(String ssmOpsItemId) {
            this.ssmOpsItemId = ssmOpsItemId;
        }

        @Override
        public final Builder ssmOpsItemId(String ssmOpsItemId) {
            this.ssmOpsItemId = ssmOpsItemId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ProactiveInsight build() {
            return new ProactiveInsight(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProactiveInsight> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder severity(String var1);

        public Builder severity(InsightSeverity var1);

        public Builder status(String var1);

        public Builder status(InsightStatus var1);

        public Builder insightTimeRange(InsightTimeRange var1);

        default public Builder insightTimeRange(Consumer<InsightTimeRange.Builder> insightTimeRange) {
            return this.insightTimeRange((InsightTimeRange)((InsightTimeRange.Builder)InsightTimeRange.builder().applyMutation(insightTimeRange)).build());
        }

        public Builder predictionTimeRange(PredictionTimeRange var1);

        default public Builder predictionTimeRange(Consumer<PredictionTimeRange.Builder> predictionTimeRange) {
            return this.predictionTimeRange((PredictionTimeRange)((PredictionTimeRange.Builder)PredictionTimeRange.builder().applyMutation(predictionTimeRange)).build());
        }

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }

        public Builder ssmOpsItemId(String var1);

        public Builder description(String var1);
    }
}

