/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Locale {
    DE_DE("DE_DE"),
    EN_US("EN_US"),
    EN_GB("EN_GB"),
    ES_ES("ES_ES"),
    FR_FR("FR_FR"),
    IT_IT("IT_IT"),
    JA_JP("JA_JP"),
    KO_KR("KO_KR"),
    PT_BR("PT_BR"),
    ZH_CN("ZH_CN"),
    ZH_TW("ZH_TW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Locale> VALUE_MAP;
    private final String value;

    private Locale(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Locale fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Locale> knownValues() {
        EnumSet<Locale> knownValues = EnumSet.allOf(Locale.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Locale.class, Locale::toString);
    }
}

