/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.ProactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest;
import software.amazon.awssdk.services.devopsguru.model.SearchInsightsResponse;

public class SearchInsightsPublisher
implements SdkPublisher<SearchInsightsResponse> {
    private final DevOpsGuruAsyncClient client;
    private final SearchInsightsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchInsightsPublisher(DevOpsGuruAsyncClient client, SearchInsightsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchInsightsPublisher(DevOpsGuruAsyncClient client, SearchInsightsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchInsightsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchInsightsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProactiveInsightSummary> proactiveInsights() {
        Function<SearchInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.proactiveInsights() != null) {
                return response.proactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchInsightsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<ReactiveInsightSummary> reactiveInsights() {
        Function<SearchInsightsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reactiveInsights() != null) {
                return response.reactiveInsights().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchInsightsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchInsightsResponseFetcher
    implements AsyncPageFetcher<SearchInsightsResponse> {
        private SearchInsightsResponseFetcher() {
        }

        public boolean hasNextPage(SearchInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchInsightsResponse> nextPage(SearchInsightsResponse previousPage) {
            if (previousPage == null) {
                return SearchInsightsPublisher.this.client.searchInsights(SearchInsightsPublisher.this.firstRequest);
            }
            return SearchInsightsPublisher.this.client.searchInsights((SearchInsightsRequest)((Object)SearchInsightsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

