/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reference scalar values and other metrics that DevOps Guru displays on a graph in its console along with the actual
 * metrics it analyzed. Compare these reference values to your actual metrics to help you understand anomalous behavior
 * that DevOps Guru detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerformanceInsightsReferenceComparisonValues implements SdkPojo, Serializable,
        ToCopyableBuilder<PerformanceInsightsReferenceComparisonValues.Builder, PerformanceInsightsReferenceComparisonValues> {
    private static final SdkField<PerformanceInsightsReferenceScalar> REFERENCE_SCALAR_FIELD = SdkField
            .<PerformanceInsightsReferenceScalar> builder(MarshallingType.SDK_POJO).memberName("ReferenceScalar")
            .getter(getter(PerformanceInsightsReferenceComparisonValues::referenceScalar))
            .setter(setter(Builder::referenceScalar)).constructor(PerformanceInsightsReferenceScalar::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceScalar").build()).build();

    private static final SdkField<PerformanceInsightsReferenceMetric> REFERENCE_METRIC_FIELD = SdkField
            .<PerformanceInsightsReferenceMetric> builder(MarshallingType.SDK_POJO).memberName("ReferenceMetric")
            .getter(getter(PerformanceInsightsReferenceComparisonValues::referenceMetric))
            .setter(setter(Builder::referenceMetric)).constructor(PerformanceInsightsReferenceMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceMetric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_SCALAR_FIELD,
            REFERENCE_METRIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final PerformanceInsightsReferenceScalar referenceScalar;

    private final PerformanceInsightsReferenceMetric referenceMetric;

    private PerformanceInsightsReferenceComparisonValues(BuilderImpl builder) {
        this.referenceScalar = builder.referenceScalar;
        this.referenceMetric = builder.referenceMetric;
    }

    /**
     * <p>
     * A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This reference value
     * is used to determine if an actual metric value should be considered anomalous.
     * </p>
     * 
     * @return A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This reference
     *         value is used to determine if an actual metric value should be considered anomalous.
     */
    public final PerformanceInsightsReferenceScalar referenceScalar() {
        return referenceScalar;
    }

    /**
     * <p>
     * A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine if an
     * actual metric should be considered anomalous.
     * </p>
     * 
     * @return A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine if
     *         an actual metric should be considered anomalous.
     */
    public final PerformanceInsightsReferenceMetric referenceMetric() {
        return referenceMetric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceScalar());
        hashCode = 31 * hashCode + Objects.hashCode(referenceMetric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsReferenceComparisonValues)) {
            return false;
        }
        PerformanceInsightsReferenceComparisonValues other = (PerformanceInsightsReferenceComparisonValues) obj;
        return Objects.equals(referenceScalar(), other.referenceScalar())
                && Objects.equals(referenceMetric(), other.referenceMetric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerformanceInsightsReferenceComparisonValues").add("ReferenceScalar", referenceScalar())
                .add("ReferenceMetric", referenceMetric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceScalar":
            return Optional.ofNullable(clazz.cast(referenceScalar()));
        case "ReferenceMetric":
            return Optional.ofNullable(clazz.cast(referenceMetric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PerformanceInsightsReferenceComparisonValues, T> g) {
        return obj -> g.apply((PerformanceInsightsReferenceComparisonValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerformanceInsightsReferenceComparisonValues> {
        /**
         * <p>
         * A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This reference
         * value is used to determine if an actual metric value should be considered anomalous.
         * </p>
         * 
         * @param referenceScalar
         *        A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This
         *        reference value is used to determine if an actual metric value should be considered anomalous.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceScalar(PerformanceInsightsReferenceScalar referenceScalar);

        /**
         * <p>
         * A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This reference
         * value is used to determine if an actual metric value should be considered anomalous.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PerformanceInsightsReferenceScalar.Builder} avoiding the need to create one manually via
         * {@link PerformanceInsightsReferenceScalar#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceInsightsReferenceScalar.Builder#build()} is called
         * immediately and its result is passed to {@link #referenceScalar(PerformanceInsightsReferenceScalar)}.
         * 
         * @param referenceScalar
         *        a consumer that will call methods on {@link PerformanceInsightsReferenceScalar.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceScalar(PerformanceInsightsReferenceScalar)
         */
        default Builder referenceScalar(Consumer<PerformanceInsightsReferenceScalar.Builder> referenceScalar) {
            return referenceScalar(PerformanceInsightsReferenceScalar.builder().applyMutation(referenceScalar).build());
        }

        /**
         * <p>
         * A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine if an
         * actual metric should be considered anomalous.
         * </p>
         * 
         * @param referenceMetric
         *        A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine
         *        if an actual metric should be considered anomalous.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceMetric(PerformanceInsightsReferenceMetric referenceMetric);

        /**
         * <p>
         * A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine if an
         * actual metric should be considered anomalous.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PerformanceInsightsReferenceMetric.Builder} avoiding the need to create one manually via
         * {@link PerformanceInsightsReferenceMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceInsightsReferenceMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #referenceMetric(PerformanceInsightsReferenceMetric)}.
         * 
         * @param referenceMetric
         *        a consumer that will call methods on {@link PerformanceInsightsReferenceMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceMetric(PerformanceInsightsReferenceMetric)
         */
        default Builder referenceMetric(Consumer<PerformanceInsightsReferenceMetric.Builder> referenceMetric) {
            return referenceMetric(PerformanceInsightsReferenceMetric.builder().applyMutation(referenceMetric).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PerformanceInsightsReferenceScalar referenceScalar;

        private PerformanceInsightsReferenceMetric referenceMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceInsightsReferenceComparisonValues model) {
            referenceScalar(model.referenceScalar);
            referenceMetric(model.referenceMetric);
        }

        public final PerformanceInsightsReferenceScalar.Builder getReferenceScalar() {
            return referenceScalar != null ? referenceScalar.toBuilder() : null;
        }

        public final void setReferenceScalar(PerformanceInsightsReferenceScalar.BuilderImpl referenceScalar) {
            this.referenceScalar = referenceScalar != null ? referenceScalar.build() : null;
        }

        @Override
        public final Builder referenceScalar(PerformanceInsightsReferenceScalar referenceScalar) {
            this.referenceScalar = referenceScalar;
            return this;
        }

        public final PerformanceInsightsReferenceMetric.Builder getReferenceMetric() {
            return referenceMetric != null ? referenceMetric.toBuilder() : null;
        }

        public final void setReferenceMetric(PerformanceInsightsReferenceMetric.BuilderImpl referenceMetric) {
            this.referenceMetric = referenceMetric != null ? referenceMetric.build() : null;
        }

        @Override
        public final Builder referenceMetric(PerformanceInsightsReferenceMetric referenceMetric) {
            this.referenceMetric = referenceMetric;
            return this;
        }

        @Override
        public PerformanceInsightsReferenceComparisonValues build() {
            return new PerformanceInsightsReferenceComparisonValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
