/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationsRequest extends DevOpsGuruRequest implements
        ToCopyableBuilder<ListRecommendationsRequest.Builder, ListRecommendationsRequest> {
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightId").getter(getter(ListRecommendationsRequest::insightId)).setter(setter(Builder::insightId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRecommendationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Locale")
            .getter(getter(ListRecommendationsRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ListRecommendationsRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ID_FIELD,
            NEXT_TOKEN_FIELD, LOCALE_FIELD, ACCOUNT_ID_FIELD));

    private final String insightId;

    private final String nextToken;

    private final String locale;

    private final String accountId;

    private ListRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.insightId = builder.insightId;
        this.nextToken = builder.nextToken;
        this.locale = builder.locale;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * The ID of the requested insight.
     * </p>
     * 
     * @return The ID of the requested insight.
     */
    public final String insightId() {
        return insightId;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A locale that specifies the language to use for recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return A locale that specifies the language to use for recommendations.
     * @see Locale
     */
    public final Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * A locale that specifies the language to use for recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return A locale that specifies the language to use for recommendations.
     * @see Locale
     */
    public final String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(insightId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsRequest)) {
            return false;
        }
        ListRecommendationsRequest other = (ListRecommendationsRequest) obj;
        return Objects.equals(insightId(), other.insightId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(localeAsString(), other.localeAsString()) && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecommendationsRequest").add("InsightId", insightId()).add("NextToken", nextToken())
                .add("Locale", localeAsString()).add("AccountId", accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsightId":
            return Optional.ofNullable(clazz.cast(insightId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationsRequest, T> g) {
        return obj -> g.apply((ListRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRecommendationsRequest> {
        /**
         * <p>
         * The ID of the requested insight.
         * </p>
         * 
         * @param insightId
         *        The ID of the requested insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightId(String insightId);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A locale that specifies the language to use for recommendations.
         * </p>
         * 
         * @param locale
         *        A locale that specifies the language to use for recommendations.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * A locale that specifies the language to use for recommendations.
         * </p>
         * 
         * @param locale
         *        A locale that specifies the language to use for recommendations.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DevOpsGuruRequest.BuilderImpl implements Builder {
        private String insightId;

        private String nextToken;

        private String locale;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationsRequest model) {
            super(model);
            insightId(model.insightId);
            nextToken(model.nextToken);
            locale(model.locale);
            accountId(model.accountId);
        }

        public final String getInsightId() {
            return insightId;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationsRequest build() {
            return new ListRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
