/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventSourcesConfigResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<DescribeEventSourcesConfigResponse.Builder, DescribeEventSourcesConfigResponse> {
    private static final SdkField<EventSourcesConfig> EVENT_SOURCES_FIELD = SdkField
            .<EventSourcesConfig> builder(MarshallingType.SDK_POJO).memberName("EventSources")
            .getter(getter(DescribeEventSourcesConfigResponse::eventSources)).setter(setter(Builder::eventSources))
            .constructor(EventSourcesConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCES_FIELD));

    private final EventSourcesConfig eventSources;

    private DescribeEventSourcesConfigResponse(BuilderImpl builder) {
        super(builder);
        this.eventSources = builder.eventSources;
    }

    /**
     * <p>
     * Lists the event sources in the configuration.
     * </p>
     * 
     * @return Lists the event sources in the configuration.
     */
    public final EventSourcesConfig eventSources() {
        return eventSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventSources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSourcesConfigResponse)) {
            return false;
        }
        DescribeEventSourcesConfigResponse other = (DescribeEventSourcesConfigResponse) obj;
        return Objects.equals(eventSources(), other.eventSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventSourcesConfigResponse").add("EventSources", eventSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSources":
            return Optional.ofNullable(clazz.cast(eventSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventSourcesConfigResponse, T> g) {
        return obj -> g.apply((DescribeEventSourcesConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEventSourcesConfigResponse> {
        /**
         * <p>
         * Lists the event sources in the configuration.
         * </p>
         * 
         * @param eventSources
         *        Lists the event sources in the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSources(EventSourcesConfig eventSources);

        /**
         * <p>
         * Lists the event sources in the configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventSourcesConfig.Builder} avoiding the
         * need to create one manually via {@link EventSourcesConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventSourcesConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #eventSources(EventSourcesConfig)}.
         * 
         * @param eventSources
         *        a consumer that will call methods on {@link EventSourcesConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSources(EventSourcesConfig)
         */
        default Builder eventSources(Consumer<EventSourcesConfig.Builder> eventSources) {
            return eventSources(EventSourcesConfig.builder().applyMutation(eventSources).build());
        }
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private EventSourcesConfig eventSources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSourcesConfigResponse model) {
            super(model);
            eventSources(model.eventSources);
        }

        public final EventSourcesConfig.Builder getEventSources() {
            return eventSources != null ? eventSources.toBuilder() : null;
        }

        public final void setEventSources(EventSourcesConfig.BuilderImpl eventSources) {
            this.eventSources = eventSources != null ? eventSources.build() : null;
        }

        @Override
        public final Builder eventSources(EventSourcesConfig eventSources) {
            this.eventSources = eventSources;
            return this;
        }

        @Override
        public DescribeEventSourcesConfigResponse build() {
            return new DescribeEventSourcesConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
