/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the analyzed metrics that displayed anomalous behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchMetricsDataSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchMetricsDataSummary.Builder, CloudWatchMetricsDataSummary> {
    private static final SdkField<List<TimestampMetricValuePair>> TIMESTAMP_METRIC_VALUE_PAIR_LIST_FIELD = SdkField
            .<List<TimestampMetricValuePair>> builder(MarshallingType.LIST)
            .memberName("TimestampMetricValuePairList")
            .getter(getter(CloudWatchMetricsDataSummary::timestampMetricValuePairList))
            .setter(setter(Builder::timestampMetricValuePairList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampMetricValuePairList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimestampMetricValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimestampMetricValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(CloudWatchMetricsDataSummary::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIMESTAMP_METRIC_VALUE_PAIR_LIST_FIELD, STATUS_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TimestampMetricValuePair> timestampMetricValuePairList;

    private final String statusCode;

    private CloudWatchMetricsDataSummary(BuilderImpl builder) {
        this.timestampMetricValuePairList = builder.timestampMetricValuePairList;
        this.statusCode = builder.statusCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimestampMetricValuePairList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTimestampMetricValuePairList() {
        return timestampMetricValuePairList != null && !(timestampMetricValuePairList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is a list of Amazon CloudWatch metric values at given timestamp.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimestampMetricValuePairList} method.
     * </p>
     * 
     * @return This is a list of Amazon CloudWatch metric values at given timestamp.
     */
    public final List<TimestampMetricValuePair> timestampMetricValuePairList() {
        return timestampMetricValuePairList;
    }

    /**
     * <p>
     * This is an enum of the status showing whether the metric value pair list has partial or complete data, or if
     * there was an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link CloudWatchMetricDataStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return This is an enum of the status showing whether the metric value pair list has partial or complete data, or
     *         if there was an error.
     * @see CloudWatchMetricDataStatusCode
     */
    public final CloudWatchMetricDataStatusCode statusCode() {
        return CloudWatchMetricDataStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * This is an enum of the status showing whether the metric value pair list has partial or complete data, or if
     * there was an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link CloudWatchMetricDataStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return This is an enum of the status showing whether the metric value pair list has partial or complete data, or
     *         if there was an error.
     * @see CloudWatchMetricDataStatusCode
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTimestampMetricValuePairList() ? timestampMetricValuePairList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchMetricsDataSummary)) {
            return false;
        }
        CloudWatchMetricsDataSummary other = (CloudWatchMetricsDataSummary) obj;
        return hasTimestampMetricValuePairList() == other.hasTimestampMetricValuePairList()
                && Objects.equals(timestampMetricValuePairList(), other.timestampMetricValuePairList())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchMetricsDataSummary")
                .add("TimestampMetricValuePairList", hasTimestampMetricValuePairList() ? timestampMetricValuePairList() : null)
                .add("StatusCode", statusCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimestampMetricValuePairList":
            return Optional.ofNullable(clazz.cast(timestampMetricValuePairList()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchMetricsDataSummary, T> g) {
        return obj -> g.apply((CloudWatchMetricsDataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchMetricsDataSummary> {
        /**
         * <p>
         * This is a list of Amazon CloudWatch metric values at given timestamp.
         * </p>
         * 
         * @param timestampMetricValuePairList
         *        This is a list of Amazon CloudWatch metric values at given timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampMetricValuePairList(Collection<TimestampMetricValuePair> timestampMetricValuePairList);

        /**
         * <p>
         * This is a list of Amazon CloudWatch metric values at given timestamp.
         * </p>
         * 
         * @param timestampMetricValuePairList
         *        This is a list of Amazon CloudWatch metric values at given timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampMetricValuePairList(TimestampMetricValuePair... timestampMetricValuePairList);

        /**
         * <p>
         * This is a list of Amazon CloudWatch metric values at given timestamp.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair.Builder#build()} is called
         * immediately and its result is passed to {@link #timestampMetricValuePairList(List<TimestampMetricValuePair>)}.
         * 
         * @param timestampMetricValuePairList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampMetricValuePairList(java.util.Collection<TimestampMetricValuePair>)
         */
        Builder timestampMetricValuePairList(Consumer<TimestampMetricValuePair.Builder>... timestampMetricValuePairList);

        /**
         * <p>
         * This is an enum of the status showing whether the metric value pair list has partial or complete data, or if
         * there was an error.
         * </p>
         * 
         * @param statusCode
         *        This is an enum of the status showing whether the metric value pair list has partial or complete data,
         *        or if there was an error.
         * @see CloudWatchMetricDataStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchMetricDataStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * This is an enum of the status showing whether the metric value pair list has partial or complete data, or if
         * there was an error.
         * </p>
         * 
         * @param statusCode
         *        This is an enum of the status showing whether the metric value pair list has partial or complete data,
         *        or if there was an error.
         * @see CloudWatchMetricDataStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchMetricDataStatusCode
         */
        Builder statusCode(CloudWatchMetricDataStatusCode statusCode);
    }

    static final class BuilderImpl implements Builder {
        private List<TimestampMetricValuePair> timestampMetricValuePairList = DefaultSdkAutoConstructList.getInstance();

        private String statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchMetricsDataSummary model) {
            timestampMetricValuePairList(model.timestampMetricValuePairList);
            statusCode(model.statusCode);
        }

        public final List<TimestampMetricValuePair.Builder> getTimestampMetricValuePairList() {
            List<TimestampMetricValuePair.Builder> result = TimestampMetricValuePairListCopier
                    .copyToBuilder(this.timestampMetricValuePairList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimestampMetricValuePairList(
                Collection<TimestampMetricValuePair.BuilderImpl> timestampMetricValuePairList) {
            this.timestampMetricValuePairList = TimestampMetricValuePairListCopier.copyFromBuilder(timestampMetricValuePairList);
        }

        @Override
        public final Builder timestampMetricValuePairList(Collection<TimestampMetricValuePair> timestampMetricValuePairList) {
            this.timestampMetricValuePairList = TimestampMetricValuePairListCopier.copy(timestampMetricValuePairList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampMetricValuePairList(TimestampMetricValuePair... timestampMetricValuePairList) {
            timestampMetricValuePairList(Arrays.asList(timestampMetricValuePairList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampMetricValuePairList(
                Consumer<TimestampMetricValuePair.Builder>... timestampMetricValuePairList) {
            timestampMetricValuePairList(Stream.of(timestampMetricValuePairList)
                    .map(c -> TimestampMetricValuePair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(CloudWatchMetricDataStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        @Override
        public CloudWatchMetricsDataSummary build() {
            return new CloudWatchMetricsDataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
