/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the source of the anomalous operational data that triggered the anomaly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalySourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalySourceDetails.Builder, AnomalySourceDetails> {
    private static final SdkField<List<CloudWatchMetricsDetail>> CLOUD_WATCH_METRICS_FIELD = SdkField
            .<List<CloudWatchMetricsDetail>> builder(MarshallingType.LIST)
            .memberName("CloudWatchMetrics")
            .getter(getter(AnomalySourceDetails::cloudWatchMetrics))
            .setter(setter(Builder::cloudWatchMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchMetricsDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchMetricsDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PerformanceInsightsMetricsDetail>> PERFORMANCE_INSIGHTS_METRICS_FIELD = SdkField
            .<List<PerformanceInsightsMetricsDetail>> builder(MarshallingType.LIST)
            .memberName("PerformanceInsightsMetrics")
            .getter(getter(AnomalySourceDetails::performanceInsightsMetrics))
            .setter(setter(Builder::performanceInsightsMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PerformanceInsightsMetricsDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PerformanceInsightsMetricsDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_METRICS_FIELD,
            PERFORMANCE_INSIGHTS_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CloudWatchMetricsDetail> cloudWatchMetrics;

    private final List<PerformanceInsightsMetricsDetail> performanceInsightsMetrics;

    private AnomalySourceDetails(BuilderImpl builder) {
        this.cloudWatchMetrics = builder.cloudWatchMetrics;
        this.performanceInsightsMetrics = builder.performanceInsightsMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchMetrics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCloudWatchMetrics() {
        return cloudWatchMetrics != null && !(cloudWatchMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed CloudWatch
     * metrics that show anomalous behavior.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudWatchMetrics} method.
     * </p>
     * 
     * @return An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed
     *         CloudWatch metrics that show anomalous behavior.
     */
    public final List<CloudWatchMetricsDetail> cloudWatchMetrics() {
        return cloudWatchMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the PerformanceInsightsMetrics property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPerformanceInsightsMetrics() {
        return performanceInsightsMetrics != null && !(performanceInsightsMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed
     * Performance Insights metrics that show anomalous behavior.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPerformanceInsightsMetrics} method.
     * </p>
     * 
     * @return An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed
     *         Performance Insights metrics that show anomalous behavior.
     */
    public final List<PerformanceInsightsMetricsDetail> performanceInsightsMetrics() {
        return performanceInsightsMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCloudWatchMetrics() ? cloudWatchMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPerformanceInsightsMetrics() ? performanceInsightsMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalySourceDetails)) {
            return false;
        }
        AnomalySourceDetails other = (AnomalySourceDetails) obj;
        return hasCloudWatchMetrics() == other.hasCloudWatchMetrics()
                && Objects.equals(cloudWatchMetrics(), other.cloudWatchMetrics())
                && hasPerformanceInsightsMetrics() == other.hasPerformanceInsightsMetrics()
                && Objects.equals(performanceInsightsMetrics(), other.performanceInsightsMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalySourceDetails")
                .add("CloudWatchMetrics", hasCloudWatchMetrics() ? cloudWatchMetrics() : null)
                .add("PerformanceInsightsMetrics", hasPerformanceInsightsMetrics() ? performanceInsightsMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchMetrics":
            return Optional.ofNullable(clazz.cast(cloudWatchMetrics()));
        case "PerformanceInsightsMetrics":
            return Optional.ofNullable(clazz.cast(performanceInsightsMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalySourceDetails, T> g) {
        return obj -> g.apply((AnomalySourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalySourceDetails> {
        /**
         * <p>
         * An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed CloudWatch
         * metrics that show anomalous behavior.
         * </p>
         * 
         * @param cloudWatchMetrics
         *        An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed
         *        CloudWatch metrics that show anomalous behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetrics(Collection<CloudWatchMetricsDetail> cloudWatchMetrics);

        /**
         * <p>
         * An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed CloudWatch
         * metrics that show anomalous behavior.
         * </p>
         * 
         * @param cloudWatchMetrics
         *        An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed
         *        CloudWatch metrics that show anomalous behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchMetrics(CloudWatchMetricsDetail... cloudWatchMetrics);

        /**
         * <p>
         * An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed CloudWatch
         * metrics that show anomalous behavior.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchMetrics(List<CloudWatchMetricsDetail>)}.
         * 
         * @param cloudWatchMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchMetrics(java.util.Collection<CloudWatchMetricsDetail>)
         */
        Builder cloudWatchMetrics(Consumer<CloudWatchMetricsDetail.Builder>... cloudWatchMetrics);

        /**
         * <p>
         * An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed
         * Performance Insights metrics that show anomalous behavior.
         * </p>
         * 
         * @param performanceInsightsMetrics
         *        An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about
         *        analyzed Performance Insights metrics that show anomalous behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsMetrics(Collection<PerformanceInsightsMetricsDetail> performanceInsightsMetrics);

        /**
         * <p>
         * An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed
         * Performance Insights metrics that show anomalous behavior.
         * </p>
         * 
         * @param performanceInsightsMetrics
         *        An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about
         *        analyzed Performance Insights metrics that show anomalous behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsMetrics(PerformanceInsightsMetricsDetail... performanceInsightsMetrics);

        /**
         * <p>
         * An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed
         * Performance Insights metrics that show anomalous behavior.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #performanceInsightsMetrics(List<PerformanceInsightsMetricsDetail>)}.
         * 
         * @param performanceInsightsMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performanceInsightsMetrics(java.util.Collection<PerformanceInsightsMetricsDetail>)
         */
        Builder performanceInsightsMetrics(Consumer<PerformanceInsightsMetricsDetail.Builder>... performanceInsightsMetrics);
    }

    static final class BuilderImpl implements Builder {
        private List<CloudWatchMetricsDetail> cloudWatchMetrics = DefaultSdkAutoConstructList.getInstance();

        private List<PerformanceInsightsMetricsDetail> performanceInsightsMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalySourceDetails model) {
            cloudWatchMetrics(model.cloudWatchMetrics);
            performanceInsightsMetrics(model.performanceInsightsMetrics);
        }

        public final List<CloudWatchMetricsDetail.Builder> getCloudWatchMetrics() {
            List<CloudWatchMetricsDetail.Builder> result = CloudWatchMetricsDetailsCopier.copyToBuilder(this.cloudWatchMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchMetrics(Collection<CloudWatchMetricsDetail.BuilderImpl> cloudWatchMetrics) {
            this.cloudWatchMetrics = CloudWatchMetricsDetailsCopier.copyFromBuilder(cloudWatchMetrics);
        }

        @Override
        public final Builder cloudWatchMetrics(Collection<CloudWatchMetricsDetail> cloudWatchMetrics) {
            this.cloudWatchMetrics = CloudWatchMetricsDetailsCopier.copy(cloudWatchMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchMetrics(CloudWatchMetricsDetail... cloudWatchMetrics) {
            cloudWatchMetrics(Arrays.asList(cloudWatchMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchMetrics(Consumer<CloudWatchMetricsDetail.Builder>... cloudWatchMetrics) {
            cloudWatchMetrics(Stream.of(cloudWatchMetrics).map(c -> CloudWatchMetricsDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PerformanceInsightsMetricsDetail.Builder> getPerformanceInsightsMetrics() {
            List<PerformanceInsightsMetricsDetail.Builder> result = PerformanceInsightsMetricsDetailsCopier
                    .copyToBuilder(this.performanceInsightsMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPerformanceInsightsMetrics(
                Collection<PerformanceInsightsMetricsDetail.BuilderImpl> performanceInsightsMetrics) {
            this.performanceInsightsMetrics = PerformanceInsightsMetricsDetailsCopier.copyFromBuilder(performanceInsightsMetrics);
        }

        @Override
        public final Builder performanceInsightsMetrics(Collection<PerformanceInsightsMetricsDetail> performanceInsightsMetrics) {
            this.performanceInsightsMetrics = PerformanceInsightsMetricsDetailsCopier.copy(performanceInsightsMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder performanceInsightsMetrics(PerformanceInsightsMetricsDetail... performanceInsightsMetrics) {
            performanceInsightsMetrics(Arrays.asList(performanceInsightsMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder performanceInsightsMetrics(
                Consumer<PerformanceInsightsMetricsDetail.Builder>... performanceInsightsMetrics) {
            performanceInsightsMetrics(Stream.of(performanceInsightsMetrics)
                    .map(c -> PerformanceInsightsMetricsDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnomalySourceDetails build() {
            return new AnomalySourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
