/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceTypeFilter {
    LOG_GROUPS("LOG_GROUPS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceTypeFilter> VALUE_MAP;
    private final String value;

    private ResourceTypeFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceTypeFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceTypeFilter> knownValues() {
        EnumSet<ResourceTypeFilter> knownValues = EnumSet.allOf(ResourceTypeFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceTypeFilter.class, ResourceTypeFilter::toString);
    }
}

