/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceCollectionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceCollectionFilter.Builder, ResourceCollectionFilter> {
    private static final SdkField<CloudFormationCollectionFilter> CLOUD_FORMATION_FIELD = SdkField
            .<CloudFormationCollectionFilter> builder(MarshallingType.SDK_POJO).memberName("CloudFormation")
            .getter(getter(ResourceCollectionFilter::cloudFormation)).setter(setter(Builder::cloudFormation))
            .constructor(CloudFormationCollectionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudFormationCollectionFilter cloudFormation;

    private ResourceCollectionFilter(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
    }

    /**
     * <p>
     * Information about AWS CloudFormation stacks. You can use stacks to specify which AWS resources in your account to
     * analyze. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>AWS
     * CloudFormation User Guide</i>.
     * </p>
     * 
     * @return Information about AWS CloudFormation stacks. You can use stacks to specify which AWS resources in your
     *         account to analyze. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the
     *         <i>AWS CloudFormation User Guide</i>.
     */
    public final CloudFormationCollectionFilter cloudFormation() {
        return cloudFormation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCollectionFilter)) {
            return false;
        }
        ResourceCollectionFilter other = (ResourceCollectionFilter) obj;
        return Objects.equals(cloudFormation(), other.cloudFormation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceCollectionFilter").add("CloudFormation", cloudFormation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFormation":
            return Optional.ofNullable(clazz.cast(cloudFormation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceCollectionFilter, T> g) {
        return obj -> g.apply((ResourceCollectionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceCollectionFilter> {
        /**
         * <p>
         * Information about AWS CloudFormation stacks. You can use stacks to specify which AWS resources in your
         * account to analyze. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>AWS
         * CloudFormation User Guide</i>.
         * </p>
         * 
         * @param cloudFormation
         *        Information about AWS CloudFormation stacks. You can use stacks to specify which AWS resources in your
         *        account to analyze. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the
         *        <i>AWS CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormation(CloudFormationCollectionFilter cloudFormation);

        /**
         * <p>
         * Information about AWS CloudFormation stacks. You can use stacks to specify which AWS resources in your
         * account to analyze. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>AWS
         * CloudFormation User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudFormationCollectionFilter.Builder} avoiding
         * the need to create one manually via {@link CloudFormationCollectionFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudFormationCollectionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudFormation(CloudFormationCollectionFilter)}.
         * 
         * @param cloudFormation
         *        a consumer that will call methods on {@link CloudFormationCollectionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormation(CloudFormationCollectionFilter)
         */
        default Builder cloudFormation(Consumer<CloudFormationCollectionFilter.Builder> cloudFormation) {
            return cloudFormation(CloudFormationCollectionFilter.builder().applyMutation(cloudFormation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudFormationCollectionFilter cloudFormation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCollectionFilter model) {
            cloudFormation(model.cloudFormation);
        }

        public final CloudFormationCollectionFilter.Builder getCloudFormation() {
            return cloudFormation != null ? cloudFormation.toBuilder() : null;
        }

        @Override
        public final Builder cloudFormation(CloudFormationCollectionFilter cloudFormation) {
            this.cloudFormation = cloudFormation;
            return this;
        }

        public final void setCloudFormation(CloudFormationCollectionFilter.BuilderImpl cloudFormation) {
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
        }

        @Override
        public ResourceCollectionFilter build() {
            return new ResourceCollectionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
