/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a reactive anomaly. This object is returned by <code>ListAnomalies</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReactiveAnomaly implements SdkPojo, Serializable, ToCopyableBuilder<ReactiveAnomaly.Builder, ReactiveAnomaly> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ReactiveAnomaly::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(ReactiveAnomaly::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReactiveAnomaly::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<AnomalyTimeRange> ANOMALY_TIME_RANGE_FIELD = SdkField
            .<AnomalyTimeRange> builder(MarshallingType.SDK_POJO).memberName("AnomalyTimeRange")
            .getter(getter(ReactiveAnomaly::anomalyTimeRange)).setter(setter(Builder::anomalyTimeRange))
            .constructor(AnomalyTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyTimeRange").build()).build();

    private static final SdkField<AnomalySourceDetails> SOURCE_DETAILS_FIELD = SdkField
            .<AnomalySourceDetails> builder(MarshallingType.SDK_POJO).memberName("SourceDetails")
            .getter(getter(ReactiveAnomaly::sourceDetails)).setter(setter(Builder::sourceDetails))
            .constructor(AnomalySourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetails").build()).build();

    private static final SdkField<String> ASSOCIATED_INSIGHT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedInsightId").getter(getter(ReactiveAnomaly::associatedInsightId))
            .setter(setter(Builder::associatedInsightId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedInsightId").build())
            .build();

    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(ReactiveAnomaly::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ID_FIELD, SEVERITY_FIELD, STATUS_FIELD, ANOMALY_TIME_RANGE_FIELD,
                    SOURCE_DETAILS_FIELD, ASSOCIATED_INSIGHT_ID_FIELD, RESOURCE_COLLECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String severity;

    private final String status;

    private final AnomalyTimeRange anomalyTimeRange;

    private final AnomalySourceDetails sourceDetails;

    private final String associatedInsightId;

    private final ResourceCollection resourceCollection;

    private ReactiveAnomaly(BuilderImpl builder) {
        this.id = builder.id;
        this.severity = builder.severity;
        this.status = builder.status;
        this.anomalyTimeRange = builder.anomalyTimeRange;
        this.sourceDetails = builder.sourceDetails;
        this.associatedInsightId = builder.associatedInsightId;
        this.resourceCollection = builder.resourceCollection;
    }

    /**
     * <p>
     * The ID of the reactive anomaly.
     * </p>
     * 
     * @return The ID of the reactive anomaly.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The severity of the anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link AnomalySeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the anomaly.
     * @see AnomalySeverity
     */
    public final AnomalySeverity severity() {
        return AnomalySeverity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of the anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link AnomalySeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the anomaly.
     * @see AnomalySeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The status of the anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnomalyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the anomaly.
     * @see AnomalyStatus
     */
    public final AnomalyStatus status() {
        return AnomalyStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnomalyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the anomaly.
     * @see AnomalyStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the AnomalyTimeRange property for this object.
     * 
     * @return The value of the AnomalyTimeRange property for this object.
     */
    public final AnomalyTimeRange anomalyTimeRange() {
        return anomalyTimeRange;
    }

    /**
     * <p>
     * Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is
     * Amazon CloudWatch metrics.
     * </p>
     * 
     * @return Details about the source of the analyzed operational data that triggered the anomaly. The one supported
     *         source is Amazon CloudWatch metrics.
     */
    public final AnomalySourceDetails sourceDetails() {
        return sourceDetails;
    }

    /**
     * <p>
     * The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
     * </p>
     * 
     * @return The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
     */
    public final String associatedInsightId() {
        return associatedInsightId;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(associatedInsightId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactiveAnomaly)) {
            return false;
        }
        ReactiveAnomaly other = (ReactiveAnomaly) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(anomalyTimeRange(), other.anomalyTimeRange())
                && Objects.equals(sourceDetails(), other.sourceDetails())
                && Objects.equals(associatedInsightId(), other.associatedInsightId())
                && Objects.equals(resourceCollection(), other.resourceCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReactiveAnomaly").add("Id", id()).add("Severity", severityAsString())
                .add("Status", statusAsString()).add("AnomalyTimeRange", anomalyTimeRange())
                .add("SourceDetails", sourceDetails()).add("AssociatedInsightId", associatedInsightId())
                .add("ResourceCollection", resourceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AnomalyTimeRange":
            return Optional.ofNullable(clazz.cast(anomalyTimeRange()));
        case "SourceDetails":
            return Optional.ofNullable(clazz.cast(sourceDetails()));
        case "AssociatedInsightId":
            return Optional.ofNullable(clazz.cast(associatedInsightId()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactiveAnomaly, T> g) {
        return obj -> g.apply((ReactiveAnomaly) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReactiveAnomaly> {
        /**
         * <p>
         * The ID of the reactive anomaly.
         * </p>
         * 
         * @param id
         *        The ID of the reactive anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The severity of the anomaly.
         * </p>
         * 
         * @param severity
         *        The severity of the anomaly.
         * @see AnomalySeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalySeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of the anomaly.
         * </p>
         * 
         * @param severity
         *        The severity of the anomaly.
         * @see AnomalySeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalySeverity
         */
        Builder severity(AnomalySeverity severity);

        /**
         * <p>
         * The status of the anomaly.
         * </p>
         * 
         * @param status
         *        The status of the anomaly.
         * @see AnomalyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the anomaly.
         * </p>
         * 
         * @param status
         *        The status of the anomaly.
         * @see AnomalyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyStatus
         */
        Builder status(AnomalyStatus status);

        /**
         * Sets the value of the AnomalyTimeRange property for this object.
         *
         * @param anomalyTimeRange
         *        The new value for the AnomalyTimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyTimeRange(AnomalyTimeRange anomalyTimeRange);

        /**
         * Sets the value of the AnomalyTimeRange property for this object.
         *
         * This is a convenience that creates an instance of the {@link AnomalyTimeRange.Builder} avoiding the need to
         * create one manually via {@link AnomalyTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnomalyTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #anomalyTimeRange(AnomalyTimeRange)}.
         * 
         * @param anomalyTimeRange
         *        a consumer that will call methods on {@link AnomalyTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyTimeRange(AnomalyTimeRange)
         */
        default Builder anomalyTimeRange(Consumer<AnomalyTimeRange.Builder> anomalyTimeRange) {
            return anomalyTimeRange(AnomalyTimeRange.builder().applyMutation(anomalyTimeRange).build());
        }

        /**
         * <p>
         * Details about the source of the analyzed operational data that triggered the anomaly. The one supported
         * source is Amazon CloudWatch metrics.
         * </p>
         * 
         * @param sourceDetails
         *        Details about the source of the analyzed operational data that triggered the anomaly. The one
         *        supported source is Amazon CloudWatch metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDetails(AnomalySourceDetails sourceDetails);

        /**
         * <p>
         * Details about the source of the analyzed operational data that triggered the anomaly. The one supported
         * source is Amazon CloudWatch metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link AnomalySourceDetails.Builder} avoiding the need
         * to create one manually via {@link AnomalySourceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnomalySourceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceDetails(AnomalySourceDetails)}.
         * 
         * @param sourceDetails
         *        a consumer that will call methods on {@link AnomalySourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDetails(AnomalySourceDetails)
         */
        default Builder sourceDetails(Consumer<AnomalySourceDetails.Builder> sourceDetails) {
            return sourceDetails(AnomalySourceDetails.builder().applyMutation(sourceDetails).build());
        }

        /**
         * <p>
         * The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
         * </p>
         * 
         * @param associatedInsightId
         *        The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedInsightId(String associatedInsightId);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceCollection.Builder} avoiding the need to
         * create one manually via {@link ResourceCollection#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String severity;

        private String status;

        private AnomalyTimeRange anomalyTimeRange;

        private AnomalySourceDetails sourceDetails;

        private String associatedInsightId;

        private ResourceCollection resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(ReactiveAnomaly model) {
            id(model.id);
            severity(model.severity);
            status(model.status);
            anomalyTimeRange(model.anomalyTimeRange);
            sourceDetails(model.sourceDetails);
            associatedInsightId(model.associatedInsightId);
            resourceCollection(model.resourceCollection);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getSeverity() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(AnomalySeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnomalyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final AnomalyTimeRange.Builder getAnomalyTimeRange() {
            return anomalyTimeRange != null ? anomalyTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder anomalyTimeRange(AnomalyTimeRange anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange;
            return this;
        }

        public final void setAnomalyTimeRange(AnomalyTimeRange.BuilderImpl anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange != null ? anomalyTimeRange.build() : null;
        }

        public final AnomalySourceDetails.Builder getSourceDetails() {
            return sourceDetails != null ? sourceDetails.toBuilder() : null;
        }

        @Override
        public final Builder sourceDetails(AnomalySourceDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            return this;
        }

        public final void setSourceDetails(AnomalySourceDetails.BuilderImpl sourceDetails) {
            this.sourceDetails = sourceDetails != null ? sourceDetails.build() : null;
        }

        public final String getAssociatedInsightId() {
            return associatedInsightId;
        }

        @Override
        public final Builder associatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
            return this;
        }

        public final void setAssociatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public ReactiveAnomaly build() {
            return new ReactiveAnomaly(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
