/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an anomaly. This object is returned by <code>ListAnomalies</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProactiveAnomaly implements SdkPojo, Serializable,
        ToCopyableBuilder<ProactiveAnomaly.Builder, ProactiveAnomaly> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ProactiveAnomaly::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(ProactiveAnomaly::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProactiveAnomaly::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime").getter(getter(ProactiveAnomaly::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()).build();

    private static final SdkField<AnomalyTimeRange> ANOMALY_TIME_RANGE_FIELD = SdkField
            .<AnomalyTimeRange> builder(MarshallingType.SDK_POJO).memberName("AnomalyTimeRange")
            .getter(getter(ProactiveAnomaly::anomalyTimeRange)).setter(setter(Builder::anomalyTimeRange))
            .constructor(AnomalyTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyTimeRange").build()).build();

    private static final SdkField<PredictionTimeRange> PREDICTION_TIME_RANGE_FIELD = SdkField
            .<PredictionTimeRange> builder(MarshallingType.SDK_POJO).memberName("PredictionTimeRange")
            .getter(getter(ProactiveAnomaly::predictionTimeRange)).setter(setter(Builder::predictionTimeRange))
            .constructor(PredictionTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionTimeRange").build())
            .build();

    private static final SdkField<AnomalySourceDetails> SOURCE_DETAILS_FIELD = SdkField
            .<AnomalySourceDetails> builder(MarshallingType.SDK_POJO).memberName("SourceDetails")
            .getter(getter(ProactiveAnomaly::sourceDetails)).setter(setter(Builder::sourceDetails))
            .constructor(AnomalySourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetails").build()).build();

    private static final SdkField<String> ASSOCIATED_INSIGHT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedInsightId").getter(getter(ProactiveAnomaly::associatedInsightId))
            .setter(setter(Builder::associatedInsightId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedInsightId").build())
            .build();

    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(ProactiveAnomaly::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final SdkField<Double> LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Limit")
            .getter(getter(ProactiveAnomaly::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SEVERITY_FIELD,
            STATUS_FIELD, UPDATE_TIME_FIELD, ANOMALY_TIME_RANGE_FIELD, PREDICTION_TIME_RANGE_FIELD, SOURCE_DETAILS_FIELD,
            ASSOCIATED_INSIGHT_ID_FIELD, RESOURCE_COLLECTION_FIELD, LIMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String severity;

    private final String status;

    private final Instant updateTime;

    private final AnomalyTimeRange anomalyTimeRange;

    private final PredictionTimeRange predictionTimeRange;

    private final AnomalySourceDetails sourceDetails;

    private final String associatedInsightId;

    private final ResourceCollection resourceCollection;

    private final Double limit;

    private ProactiveAnomaly(BuilderImpl builder) {
        this.id = builder.id;
        this.severity = builder.severity;
        this.status = builder.status;
        this.updateTime = builder.updateTime;
        this.anomalyTimeRange = builder.anomalyTimeRange;
        this.predictionTimeRange = builder.predictionTimeRange;
        this.sourceDetails = builder.sourceDetails;
        this.associatedInsightId = builder.associatedInsightId;
        this.resourceCollection = builder.resourceCollection;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The ID of a proactive anomaly.
     * </p>
     * 
     * @return The ID of a proactive anomaly.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The severity of a proactive anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link AnomalySeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of a proactive anomaly.
     * @see AnomalySeverity
     */
    public final AnomalySeverity severity() {
        return AnomalySeverity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of a proactive anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link AnomalySeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of a proactive anomaly.
     * @see AnomalySeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The status of a proactive anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnomalyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a proactive anomaly.
     * @see AnomalyStatus
     */
    public final AnomalyStatus status() {
        return AnomalyStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a proactive anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnomalyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a proactive anomaly.
     * @see AnomalyStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time of the anomaly's most recent update.
     * </p>
     * 
     * @return The time of the anomaly's most recent update.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * Returns the value of the AnomalyTimeRange property for this object.
     * 
     * @return The value of the AnomalyTimeRange property for this object.
     */
    public final AnomalyTimeRange anomalyTimeRange() {
        return anomalyTimeRange;
    }

    /**
     * Returns the value of the PredictionTimeRange property for this object.
     * 
     * @return The value of the PredictionTimeRange property for this object.
     */
    public final PredictionTimeRange predictionTimeRange() {
        return predictionTimeRange;
    }

    /**
     * <p>
     * Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is
     * Amazon CloudWatch metrics.
     * </p>
     * 
     * @return Details about the source of the analyzed operational data that triggered the anomaly. The one supported
     *         source is Amazon CloudWatch metrics.
     */
    public final AnomalySourceDetails sourceDetails() {
        return sourceDetails;
    }

    /**
     * <p>
     * The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
     * </p>
     * 
     * @return The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
     */
    public final String associatedInsightId() {
        return associatedInsightId;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    /**
     * <p>
     * A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the
     * anomalous behavior that generated this anomaly.
     * </p>
     * 
     * @return A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to
     *         the anomalous behavior that generated this anomaly.
     */
    public final Double limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(predictionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(associatedInsightId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProactiveAnomaly)) {
            return false;
        }
        ProactiveAnomaly other = (ProactiveAnomaly) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(anomalyTimeRange(), other.anomalyTimeRange())
                && Objects.equals(predictionTimeRange(), other.predictionTimeRange())
                && Objects.equals(sourceDetails(), other.sourceDetails())
                && Objects.equals(associatedInsightId(), other.associatedInsightId())
                && Objects.equals(resourceCollection(), other.resourceCollection()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProactiveAnomaly").add("Id", id()).add("Severity", severityAsString())
                .add("Status", statusAsString()).add("UpdateTime", updateTime()).add("AnomalyTimeRange", anomalyTimeRange())
                .add("PredictionTimeRange", predictionTimeRange()).add("SourceDetails", sourceDetails())
                .add("AssociatedInsightId", associatedInsightId()).add("ResourceCollection", resourceCollection())
                .add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "AnomalyTimeRange":
            return Optional.ofNullable(clazz.cast(anomalyTimeRange()));
        case "PredictionTimeRange":
            return Optional.ofNullable(clazz.cast(predictionTimeRange()));
        case "SourceDetails":
            return Optional.ofNullable(clazz.cast(sourceDetails()));
        case "AssociatedInsightId":
            return Optional.ofNullable(clazz.cast(associatedInsightId()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProactiveAnomaly, T> g) {
        return obj -> g.apply((ProactiveAnomaly) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProactiveAnomaly> {
        /**
         * <p>
         * The ID of a proactive anomaly.
         * </p>
         * 
         * @param id
         *        The ID of a proactive anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The severity of a proactive anomaly.
         * </p>
         * 
         * @param severity
         *        The severity of a proactive anomaly.
         * @see AnomalySeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalySeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of a proactive anomaly.
         * </p>
         * 
         * @param severity
         *        The severity of a proactive anomaly.
         * @see AnomalySeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalySeverity
         */
        Builder severity(AnomalySeverity severity);

        /**
         * <p>
         * The status of a proactive anomaly.
         * </p>
         * 
         * @param status
         *        The status of a proactive anomaly.
         * @see AnomalyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a proactive anomaly.
         * </p>
         * 
         * @param status
         *        The status of a proactive anomaly.
         * @see AnomalyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyStatus
         */
        Builder status(AnomalyStatus status);

        /**
         * <p>
         * The time of the anomaly's most recent update.
         * </p>
         * 
         * @param updateTime
         *        The time of the anomaly's most recent update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * Sets the value of the AnomalyTimeRange property for this object.
         *
         * @param anomalyTimeRange
         *        The new value for the AnomalyTimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyTimeRange(AnomalyTimeRange anomalyTimeRange);

        /**
         * Sets the value of the AnomalyTimeRange property for this object.
         *
         * This is a convenience that creates an instance of the {@link AnomalyTimeRange.Builder} avoiding the need to
         * create one manually via {@link AnomalyTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnomalyTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #anomalyTimeRange(AnomalyTimeRange)}.
         * 
         * @param anomalyTimeRange
         *        a consumer that will call methods on {@link AnomalyTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyTimeRange(AnomalyTimeRange)
         */
        default Builder anomalyTimeRange(Consumer<AnomalyTimeRange.Builder> anomalyTimeRange) {
            return anomalyTimeRange(AnomalyTimeRange.builder().applyMutation(anomalyTimeRange).build());
        }

        /**
         * Sets the value of the PredictionTimeRange property for this object.
         *
         * @param predictionTimeRange
         *        The new value for the PredictionTimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionTimeRange(PredictionTimeRange predictionTimeRange);

        /**
         * Sets the value of the PredictionTimeRange property for this object.
         *
         * This is a convenience that creates an instance of the {@link PredictionTimeRange.Builder} avoiding the need
         * to create one manually via {@link PredictionTimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link PredictionTimeRange.Builder#build()} is called immediately and
         * its result is passed to {@link #predictionTimeRange(PredictionTimeRange)}.
         * 
         * @param predictionTimeRange
         *        a consumer that will call methods on {@link PredictionTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictionTimeRange(PredictionTimeRange)
         */
        default Builder predictionTimeRange(Consumer<PredictionTimeRange.Builder> predictionTimeRange) {
            return predictionTimeRange(PredictionTimeRange.builder().applyMutation(predictionTimeRange).build());
        }

        /**
         * <p>
         * Details about the source of the analyzed operational data that triggered the anomaly. The one supported
         * source is Amazon CloudWatch metrics.
         * </p>
         * 
         * @param sourceDetails
         *        Details about the source of the analyzed operational data that triggered the anomaly. The one
         *        supported source is Amazon CloudWatch metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDetails(AnomalySourceDetails sourceDetails);

        /**
         * <p>
         * Details about the source of the analyzed operational data that triggered the anomaly. The one supported
         * source is Amazon CloudWatch metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link AnomalySourceDetails.Builder} avoiding the need
         * to create one manually via {@link AnomalySourceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnomalySourceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceDetails(AnomalySourceDetails)}.
         * 
         * @param sourceDetails
         *        a consumer that will call methods on {@link AnomalySourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDetails(AnomalySourceDetails)
         */
        default Builder sourceDetails(Consumer<AnomalySourceDetails.Builder> sourceDetails) {
            return sourceDetails(AnomalySourceDetails.builder().applyMutation(sourceDetails).build());
        }

        /**
         * <p>
         * The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
         * </p>
         * 
         * @param associatedInsightId
         *        The ID of the insight that contains this anomaly. An insight is composed of related anomalies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedInsightId(String associatedInsightId);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience that creates an instance of the {@link ResourceCollection.Builder} avoiding the need to
         * create one manually via {@link ResourceCollection#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }

        /**
         * <p>
         * A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the
         * anomalous behavior that generated this anomaly.
         * </p>
         * 
         * @param limit
         *        A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related
         *        to the anomalous behavior that generated this anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Double limit);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String severity;

        private String status;

        private Instant updateTime;

        private AnomalyTimeRange anomalyTimeRange;

        private PredictionTimeRange predictionTimeRange;

        private AnomalySourceDetails sourceDetails;

        private String associatedInsightId;

        private ResourceCollection resourceCollection;

        private Double limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ProactiveAnomaly model) {
            id(model.id);
            severity(model.severity);
            status(model.status);
            updateTime(model.updateTime);
            anomalyTimeRange(model.anomalyTimeRange);
            predictionTimeRange(model.predictionTimeRange);
            sourceDetails(model.sourceDetails);
            associatedInsightId(model.associatedInsightId);
            resourceCollection(model.resourceCollection);
            limit(model.limit);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getSeverity() {
            return severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(AnomalySeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnomalyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final AnomalyTimeRange.Builder getAnomalyTimeRange() {
            return anomalyTimeRange != null ? anomalyTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder anomalyTimeRange(AnomalyTimeRange anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange;
            return this;
        }

        public final void setAnomalyTimeRange(AnomalyTimeRange.BuilderImpl anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange != null ? anomalyTimeRange.build() : null;
        }

        public final PredictionTimeRange.Builder getPredictionTimeRange() {
            return predictionTimeRange != null ? predictionTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder predictionTimeRange(PredictionTimeRange predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange;
            return this;
        }

        public final void setPredictionTimeRange(PredictionTimeRange.BuilderImpl predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange != null ? predictionTimeRange.build() : null;
        }

        public final AnomalySourceDetails.Builder getSourceDetails() {
            return sourceDetails != null ? sourceDetails.toBuilder() : null;
        }

        @Override
        public final Builder sourceDetails(AnomalySourceDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            return this;
        }

        public final void setSourceDetails(AnomalySourceDetails.BuilderImpl sourceDetails) {
            this.sourceDetails = sourceDetails != null ? sourceDetails.build() : null;
        }

        public final String getAssociatedInsightId() {
            return associatedInsightId;
        }

        @Override
        public final Builder associatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
            return this;
        }

        public final void setAssociatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        public final Double getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Double limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Double limit) {
            this.limit = limit;
        }

        @Override
        public ProactiveAnomaly build() {
            return new ProactiveAnomaly(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
