/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon CloudWatch metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchMetricsDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchMetricsDetail.Builder, CloudWatchMetricsDetail> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(CloudWatchMetricsDetail::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(CloudWatchMetricsDetail::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<List<CloudWatchMetricsDimension>> DIMENSIONS_FIELD = SdkField
            .<List<CloudWatchMetricsDimension>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(CloudWatchMetricsDetail::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchMetricsDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchMetricsDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stat")
            .getter(getter(CloudWatchMetricsDetail::statAsString)).setter(setter(Builder::stat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(CloudWatchMetricsDetail::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(CloudWatchMetricsDetail::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            NAMESPACE_FIELD, DIMENSIONS_FIELD, STAT_FIELD, UNIT_FIELD, PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String namespace;

    private final List<CloudWatchMetricsDimension> dimensions;

    private final String stat;

    private final String unit;

    private final Integer period;

    private CloudWatchMetricsDetail(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.dimensions = builder.dimensions;
        this.stat = builder.stat;
        this.unit = builder.unit;
        this.period = builder.period;
    }

    /**
     * <p>
     * The name of the CloudWatch metric.
     * </p>
     * 
     * @return The name of the CloudWatch metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
     * </p>
     * 
     * @return The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * Returns true if the Dimensions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of CloudWatch dimensions associated with
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDimensions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of CloudWatch dimensions associated with
     */
    public final List<CloudWatchMetricsDimension> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The type of statistic associated with the CloudWatch metric. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stat} will return
     * {@link CloudWatchMetricsStat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statAsString}.
     * </p>
     * 
     * @return The type of statistic associated with the CloudWatch metric. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     *         >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
     * @see CloudWatchMetricsStat
     */
    public final CloudWatchMetricsStat stat() {
        return CloudWatchMetricsStat.fromValue(stat);
    }

    /**
     * <p>
     * The type of statistic associated with the CloudWatch metric. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stat} will return
     * {@link CloudWatchMetricsStat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statAsString}.
     * </p>
     * 
     * @return The type of statistic associated with the CloudWatch metric. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
     *         >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
     * @see CloudWatchMetricsStat
     */
    public final String statAsString() {
        return stat;
    }

    /**
     * <p>
     * The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>,
     * <code>Count</code>, and <code>Percent</code>.
     * </p>
     * 
     * @return The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>
     *         , <code>Count</code>, and <code>Percent</code>.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The length of time associated with the CloudWatch metric in number of seconds.
     * </p>
     * 
     * @return The length of time associated with the CloudWatch metric in number of seconds.
     */
    public final Integer period() {
        return period;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchMetricsDetail)) {
            return false;
        }
        CloudWatchMetricsDetail other = (CloudWatchMetricsDetail) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(namespace(), other.namespace())
                && hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(statAsString(), other.statAsString()) && Objects.equals(unit(), other.unit())
                && Objects.equals(period(), other.period());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchMetricsDetail").add("MetricName", metricName()).add("Namespace", namespace())
                .add("Dimensions", hasDimensions() ? dimensions() : null).add("Stat", statAsString()).add("Unit", unit())
                .add("Period", period()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Stat":
            return Optional.ofNullable(clazz.cast(statAsString()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchMetricsDetail, T> g) {
        return obj -> g.apply((CloudWatchMetricsDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchMetricsDetail> {
        /**
         * <p>
         * The name of the CloudWatch metric.
         * </p>
         * 
         * @param metricName
         *        The name of the CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
         * </p>
         * 
         * @param namespace
         *        The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * An array of CloudWatch dimensions associated with
         * </p>
         * 
         * @param dimensions
         *        An array of CloudWatch dimensions associated with
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<CloudWatchMetricsDimension> dimensions);

        /**
         * <p>
         * An array of CloudWatch dimensions associated with
         * </p>
         * 
         * @param dimensions
         *        An array of CloudWatch dimensions associated with
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(CloudWatchMetricsDimension... dimensions);

        /**
         * <p>
         * An array of CloudWatch dimensions associated with
         * </p>
         * This is a convenience that creates an instance of the {@link List<CloudWatchMetricsDimension>.Builder}
         * avoiding the need to create one manually via {@link List<CloudWatchMetricsDimension>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchMetricsDimension>.Builder#build()} is called
         * immediately and its result is passed to {@link #dimensions(List<CloudWatchMetricsDimension>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link List<CloudWatchMetricsDimension>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(List<CloudWatchMetricsDimension>)
         */
        Builder dimensions(Consumer<CloudWatchMetricsDimension.Builder>... dimensions);

        /**
         * <p>
         * The type of statistic associated with the CloudWatch metric. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * 
         * @param stat
         *        The type of statistic associated with the CloudWatch metric. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         *        >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * @see CloudWatchMetricsStat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchMetricsStat
         */
        Builder stat(String stat);

        /**
         * <p>
         * The type of statistic associated with the CloudWatch metric. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         * >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * 
         * @param stat
         *        The type of statistic associated with the CloudWatch metric. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic"
         *        >Statistics</a> in the <i>Amazon CloudWatch User Guide</i>.
         * @see CloudWatchMetricsStat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchMetricsStat
         */
        Builder stat(CloudWatchMetricsStat stat);

        /**
         * <p>
         * The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>,
         * <code>Count</code>, and <code>Percent</code>.
         * </p>
         * 
         * @param unit
         *        The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>,
         *        <code>Seconds</code>, <code>Count</code>, and <code>Percent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The length of time associated with the CloudWatch metric in number of seconds.
         * </p>
         * 
         * @param period
         *        The length of time associated with the CloudWatch metric in number of seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String namespace;

        private List<CloudWatchMetricsDimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private String stat;

        private String unit;

        private Integer period;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchMetricsDetail model) {
            metricName(model.metricName);
            namespace(model.namespace);
            dimensions(model.dimensions);
            stat(model.stat);
            unit(model.unit);
            period(model.period);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<CloudWatchMetricsDimension.Builder> getDimensions() {
            if (dimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensions != null ? dimensions.stream().map(CloudWatchMetricsDimension::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<CloudWatchMetricsDimension> dimensions) {
            this.dimensions = CloudWatchMetricsDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(CloudWatchMetricsDimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<CloudWatchMetricsDimension.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> CloudWatchMetricsDimension.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<CloudWatchMetricsDimension.BuilderImpl> dimensions) {
            this.dimensions = CloudWatchMetricsDimensionsCopier.copyFromBuilder(dimensions);
        }

        public final String getStat() {
            return stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        @Override
        public final Builder stat(CloudWatchMetricsStat stat) {
            this.stat(stat == null ? null : stat.toString());
            return this;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public CloudWatchMetricsDetail build() {
            return new CloudWatchMetricsDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
