/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about AWS CloudFormation stacks. You can use stacks to specify which AWS resources in your account to
 * analyze. For more information, see <a
 * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>AWS
 * CloudFormation User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudFormationCollectionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudFormationCollectionFilter.Builder, CloudFormationCollectionFilter> {
    private static final SdkField<List<String>> STACK_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StackNames")
            .getter(getter(CloudFormationCollectionFilter::stackNames))
            .setter(setter(Builder::stackNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> stackNames;

    private CloudFormationCollectionFilter(BuilderImpl builder) {
        this.stackNames = builder.stackNames;
    }

    /**
     * Returns true if the StackNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStackNames() {
        return stackNames != null && !(stackNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of CloudFormation stack names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStackNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of CloudFormation stack names.
     */
    public final List<String> stackNames() {
        return stackNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStackNames() ? stackNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationCollectionFilter)) {
            return false;
        }
        CloudFormationCollectionFilter other = (CloudFormationCollectionFilter) obj;
        return hasStackNames() == other.hasStackNames() && Objects.equals(stackNames(), other.stackNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudFormationCollectionFilter").add("StackNames", hasStackNames() ? stackNames() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackNames":
            return Optional.ofNullable(clazz.cast(stackNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationCollectionFilter, T> g) {
        return obj -> g.apply((CloudFormationCollectionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudFormationCollectionFilter> {
        /**
         * <p>
         * An array of CloudFormation stack names.
         * </p>
         * 
         * @param stackNames
         *        An array of CloudFormation stack names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackNames(Collection<String> stackNames);

        /**
         * <p>
         * An array of CloudFormation stack names.
         * </p>
         * 
         * @param stackNames
         *        An array of CloudFormation stack names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackNames(String... stackNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> stackNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationCollectionFilter model) {
            stackNames(model.stackNames);
        }

        public final Collection<String> getStackNames() {
            if (stackNames instanceof SdkAutoConstructList) {
                return null;
            }
            return stackNames;
        }

        @Override
        public final Builder stackNames(Collection<String> stackNames) {
            this.stackNames = StackNamesCopier.copy(stackNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackNames(String... stackNames) {
            stackNames(Arrays.asList(stackNames));
            return this;
        }

        public final void setStackNames(Collection<String> stackNames) {
            this.stackNames = StackNamesCopier.copy(stackNames);
        }

        @Override
        public CloudFormationCollectionFilter build() {
            return new CloudFormationCollectionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
