/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.AnomalySeverity;
import software.amazon.awssdk.services.devopsguru.model.AnomalySourceDetails;
import software.amazon.awssdk.services.devopsguru.model.AnomalyStatus;
import software.amazon.awssdk.services.devopsguru.model.AnomalyTimeRange;
import software.amazon.awssdk.services.devopsguru.model.PredictionTimeRange;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProactiveAnomalySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProactiveAnomalySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::id)).setter(ProactiveAnomalySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::severityAsString)).setter(ProactiveAnomalySummary.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::statusAsString)).setter(ProactiveAnomalySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::updateTime)).setter(ProactiveAnomalySummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()}).build();
    private static final SdkField<AnomalyTimeRange> ANOMALY_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyTimeRange").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::anomalyTimeRange)).setter(ProactiveAnomalySummary.setter(Builder::anomalyTimeRange)).constructor(AnomalyTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyTimeRange").build()}).build();
    private static final SdkField<PredictionTimeRange> PREDICTION_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredictionTimeRange").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::predictionTimeRange)).setter(ProactiveAnomalySummary.setter(Builder::predictionTimeRange)).constructor(PredictionTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionTimeRange").build()}).build();
    private static final SdkField<AnomalySourceDetails> SOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDetails").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::sourceDetails)).setter(ProactiveAnomalySummary.setter(Builder::sourceDetails)).constructor(AnomalySourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetails").build()}).build();
    private static final SdkField<String> ASSOCIATED_INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedInsightId").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::associatedInsightId)).setter(ProactiveAnomalySummary.setter(Builder::associatedInsightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedInsightId").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::resourceCollection)).setter(ProactiveAnomalySummary.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<Double> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Limit").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::limit)).setter(ProactiveAnomalySummary.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SEVERITY_FIELD, STATUS_FIELD, UPDATE_TIME_FIELD, ANOMALY_TIME_RANGE_FIELD, PREDICTION_TIME_RANGE_FIELD, SOURCE_DETAILS_FIELD, ASSOCIATED_INSIGHT_ID_FIELD, RESOURCE_COLLECTION_FIELD, LIMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String severity;
    private final String status;
    private final Instant updateTime;
    private final AnomalyTimeRange anomalyTimeRange;
    private final PredictionTimeRange predictionTimeRange;
    private final AnomalySourceDetails sourceDetails;
    private final String associatedInsightId;
    private final ResourceCollection resourceCollection;
    private final Double limit;

    private ProactiveAnomalySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.severity = builder.severity;
        this.status = builder.status;
        this.updateTime = builder.updateTime;
        this.anomalyTimeRange = builder.anomalyTimeRange;
        this.predictionTimeRange = builder.predictionTimeRange;
        this.sourceDetails = builder.sourceDetails;
        this.associatedInsightId = builder.associatedInsightId;
        this.resourceCollection = builder.resourceCollection;
        this.limit = builder.limit;
    }

    public String id() {
        return this.id;
    }

    public AnomalySeverity severity() {
        return AnomalySeverity.fromValue(this.severity);
    }

    public String severityAsString() {
        return this.severity;
    }

    public AnomalyStatus status() {
        return AnomalyStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public AnomalyTimeRange anomalyTimeRange() {
        return this.anomalyTimeRange;
    }

    public PredictionTimeRange predictionTimeRange() {
        return this.predictionTimeRange;
    }

    public AnomalySourceDetails sourceDetails() {
        return this.sourceDetails;
    }

    public String associatedInsightId() {
        return this.associatedInsightId;
    }

    public ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public Double limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedInsightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProactiveAnomalySummary)) {
            return false;
        }
        ProactiveAnomalySummary other = (ProactiveAnomalySummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.anomalyTimeRange(), other.anomalyTimeRange()) && Objects.equals(this.predictionTimeRange(), other.predictionTimeRange()) && Objects.equals(this.sourceDetails(), other.sourceDetails()) && Objects.equals(this.associatedInsightId(), other.associatedInsightId()) && Objects.equals(this.resourceCollection(), other.resourceCollection()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"ProactiveAnomalySummary").add("Id", (Object)this.id()).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).add("UpdateTime", (Object)this.updateTime()).add("AnomalyTimeRange", (Object)this.anomalyTimeRange()).add("PredictionTimeRange", (Object)this.predictionTimeRange()).add("SourceDetails", (Object)this.sourceDetails()).add("AssociatedInsightId", (Object)this.associatedInsightId()).add("ResourceCollection", (Object)this.resourceCollection()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "AnomalyTimeRange": {
                return Optional.ofNullable(clazz.cast(this.anomalyTimeRange()));
            }
            case "PredictionTimeRange": {
                return Optional.ofNullable(clazz.cast(this.predictionTimeRange()));
            }
            case "SourceDetails": {
                return Optional.ofNullable(clazz.cast(this.sourceDetails()));
            }
            case "AssociatedInsightId": {
                return Optional.ofNullable(clazz.cast(this.associatedInsightId()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProactiveAnomalySummary, T> g) {
        return obj -> g.apply((ProactiveAnomalySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String severity;
        private String status;
        private Instant updateTime;
        private AnomalyTimeRange anomalyTimeRange;
        private PredictionTimeRange predictionTimeRange;
        private AnomalySourceDetails sourceDetails;
        private String associatedInsightId;
        private ResourceCollection resourceCollection;
        private Double limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ProactiveAnomalySummary model) {
            this.id(model.id);
            this.severity(model.severity);
            this.status(model.status);
            this.updateTime(model.updateTime);
            this.anomalyTimeRange(model.anomalyTimeRange);
            this.predictionTimeRange(model.predictionTimeRange);
            this.sourceDetails(model.sourceDetails);
            this.associatedInsightId(model.associatedInsightId);
            this.resourceCollection(model.resourceCollection);
            this.limit(model.limit);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(AnomalySeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnomalyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final AnomalyTimeRange.Builder getAnomalyTimeRange() {
            return this.anomalyTimeRange != null ? this.anomalyTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder anomalyTimeRange(AnomalyTimeRange anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange;
            return this;
        }

        public final void setAnomalyTimeRange(AnomalyTimeRange.BuilderImpl anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange != null ? anomalyTimeRange.build() : null;
        }

        public final PredictionTimeRange.Builder getPredictionTimeRange() {
            return this.predictionTimeRange != null ? this.predictionTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder predictionTimeRange(PredictionTimeRange predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange;
            return this;
        }

        public final void setPredictionTimeRange(PredictionTimeRange.BuilderImpl predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange != null ? predictionTimeRange.build() : null;
        }

        public final AnomalySourceDetails.Builder getSourceDetails() {
            return this.sourceDetails != null ? this.sourceDetails.toBuilder() : null;
        }

        @Override
        public final Builder sourceDetails(AnomalySourceDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            return this;
        }

        public final void setSourceDetails(AnomalySourceDetails.BuilderImpl sourceDetails) {
            this.sourceDetails = sourceDetails != null ? sourceDetails.build() : null;
        }

        public final String getAssociatedInsightId() {
            return this.associatedInsightId;
        }

        @Override
        public final Builder associatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
            return this;
        }

        public final void setAssociatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        public final Double getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Double limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Double limit) {
            this.limit = limit;
        }

        public ProactiveAnomalySummary build() {
            return new ProactiveAnomalySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProactiveAnomalySummary> {
        public Builder id(String var1);

        public Builder severity(String var1);

        public Builder severity(AnomalySeverity var1);

        public Builder status(String var1);

        public Builder status(AnomalyStatus var1);

        public Builder updateTime(Instant var1);

        public Builder anomalyTimeRange(AnomalyTimeRange var1);

        default public Builder anomalyTimeRange(Consumer<AnomalyTimeRange.Builder> anomalyTimeRange) {
            return this.anomalyTimeRange((AnomalyTimeRange)((AnomalyTimeRange.Builder)AnomalyTimeRange.builder().applyMutation(anomalyTimeRange)).build());
        }

        public Builder predictionTimeRange(PredictionTimeRange var1);

        default public Builder predictionTimeRange(Consumer<PredictionTimeRange.Builder> predictionTimeRange) {
            return this.predictionTimeRange((PredictionTimeRange)((PredictionTimeRange.Builder)PredictionTimeRange.builder().applyMutation(predictionTimeRange)).build());
        }

        public Builder sourceDetails(AnomalySourceDetails var1);

        default public Builder sourceDetails(Consumer<AnomalySourceDetails.Builder> sourceDetails) {
            return this.sourceDetails((AnomalySourceDetails)((AnomalySourceDetails.Builder)AnomalySourceDetails.builder().applyMutation(sourceDetails)).build());
        }

        public Builder associatedInsightId(String var1);

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }

        public Builder limit(Double var1);
    }
}

