/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictionTimeRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictionTimeRange> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(PredictionTimeRange.getter(PredictionTimeRange::endTime)).setter(PredictionTimeRange.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(PredictionTimeRange.getter(PredictionTimeRange::startTime)).setter(PredictionTimeRange.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant endTime;
    private final Instant startTime;

    private PredictionTimeRange(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictionTimeRange)) {
            return false;
        }
        PredictionTimeRange other = (PredictionTimeRange)obj;
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.startTime(), other.startTime());
    }

    public String toString() {
        return ToString.builder((String)"PredictionTimeRange").add("EndTime", (Object)this.endTime()).add("StartTime", (Object)this.startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictionTimeRange, T> g) {
        return obj -> g.apply((PredictionTimeRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant endTime;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictionTimeRange model) {
            this.endTime(model.endTime);
            this.startTime(model.startTime);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public PredictionTimeRange build() {
            return new PredictionTimeRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictionTimeRange> {
        public Builder endTime(Instant var1);

        public Builder startTime(Instant var1);
    }
}

