/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CPU
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CPU> {
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CPU.getter(CPU::frequency)).setter(CPU.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CPU.getter(CPU::architecture)).setter(CPU.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<Double> CLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(CPU.getter(CPU::clock)).setter(CPU.setter(Builder::clock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FREQUENCY_FIELD, ARCHITECTURE_FIELD, CLOCK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String frequency;
    private final String architecture;
    private final Double clock;

    private CPU(BuilderImpl builder) {
        this.frequency = builder.frequency;
        this.architecture = builder.architecture;
        this.clock = builder.clock;
    }

    public String frequency() {
        return this.frequency;
    }

    public String architecture() {
        return this.architecture;
    }

    public Double clock() {
        return this.clock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.clock());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CPU)) {
            return false;
        }
        CPU other = (CPU)obj;
        return Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.clock(), other.clock());
    }

    public String toString() {
        return ToString.builder((String)"CPU").add("Frequency", (Object)this.frequency()).add("Architecture", (Object)this.architecture()).add("Clock", (Object)this.clock()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "clock": {
                return Optional.ofNullable(clazz.cast(this.clock()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CPU, T> g) {
        return obj -> g.apply((CPU)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String frequency;
        private String architecture;
        private Double clock;

        private BuilderImpl() {
        }

        private BuilderImpl(CPU model) {
            this.frequency(model.frequency);
            this.architecture(model.architecture);
            this.clock(model.clock);
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Double getClock() {
            return this.clock;
        }

        @Override
        public final Builder clock(Double clock) {
            this.clock = clock;
            return this;
        }

        public final void setClock(Double clock) {
            this.clock = clock;
        }

        public CPU build() {
            return new CPU(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CPU> {
        public Builder frequency(String var1);

        public Builder architecture(String var1);

        public Builder clock(Double var1);
    }
}

