/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.Offering;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OfferingStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OfferingStatus> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OfferingStatus.getter(OfferingStatus::typeAsString)).setter(OfferingStatus.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Offering> OFFERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OfferingStatus.getter(OfferingStatus::offering)).setter(OfferingStatus.setter(Builder::offering)).constructor(Offering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offering").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OfferingStatus.getter(OfferingStatus::quantity)).setter(OfferingStatus.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantity").build()}).build();
    private static final SdkField<Instant> EFFECTIVE_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(OfferingStatus.getter(OfferingStatus::effectiveOn)).setter(OfferingStatus.setter(Builder::effectiveOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveOn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, OFFERING_FIELD, QUANTITY_FIELD, EFFECTIVE_ON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Offering offering;
    private final Integer quantity;
    private final Instant effectiveOn;

    private OfferingStatus(BuilderImpl builder) {
        this.type = builder.type;
        this.offering = builder.offering;
        this.quantity = builder.quantity;
        this.effectiveOn = builder.effectiveOn;
    }

    public OfferingTransactionType type() {
        return OfferingTransactionType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Offering offering() {
        return this.offering;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public Instant effectiveOn() {
        return this.effectiveOn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offering());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveOn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferingStatus)) {
            return false;
        }
        OfferingStatus other = (OfferingStatus)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.offering(), other.offering()) && Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.effectiveOn(), other.effectiveOn());
    }

    public String toString() {
        return ToString.builder((String)"OfferingStatus").add("Type", (Object)this.typeAsString()).add("Offering", (Object)this.offering()).add("Quantity", (Object)this.quantity()).add("EffectiveOn", (Object)this.effectiveOn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "offering": {
                return Optional.ofNullable(clazz.cast(this.offering()));
            }
            case "quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "effectiveOn": {
                return Optional.ofNullable(clazz.cast(this.effectiveOn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OfferingStatus, T> g) {
        return obj -> g.apply((OfferingStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Offering offering;
        private Integer quantity;
        private Instant effectiveOn;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferingStatus model) {
            this.type(model.type);
            this.offering(model.offering);
            this.quantity(model.quantity);
            this.effectiveOn(model.effectiveOn);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OfferingTransactionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Offering.Builder getOffering() {
            return this.offering != null ? this.offering.toBuilder() : null;
        }

        @Override
        public final Builder offering(Offering offering) {
            this.offering = offering;
            return this;
        }

        public final void setOffering(Offering.BuilderImpl offering) {
            this.offering = offering != null ? offering.build() : null;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Instant getEffectiveOn() {
            return this.effectiveOn;
        }

        @Override
        public final Builder effectiveOn(Instant effectiveOn) {
            this.effectiveOn = effectiveOn;
            return this;
        }

        public final void setEffectiveOn(Instant effectiveOn) {
            this.effectiveOn = effectiveOn;
        }

        public OfferingStatus build() {
            return new OfferingStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OfferingStatus> {
        public Builder type(String var1);

        public Builder type(OfferingTransactionType var1);

        public Builder offering(Offering var1);

        default public Builder offering(Consumer<Offering.Builder> offering) {
            return this.offering((Offering)((Offering.Builder)Offering.builder().applyMutation(offering)).build());
        }

        public Builder quantity(Integer var1);

        public Builder effectiveOn(Instant var1);
    }
}

