/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFilter;
import software.amazon.awssdk.services.devicefarm.model.DeviceFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceSelectionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceSelectionResult> {
    private static final SdkField<List<DeviceFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeviceSelectionResult.getter(DeviceSelectionResult::filters)).setter(DeviceSelectionResult.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MATCHED_DEVICES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DeviceSelectionResult.getter(DeviceSelectionResult::matchedDevicesCount)).setter(DeviceSelectionResult.setter(Builder::matchedDevicesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchedDevicesCount").build()}).build();
    private static final SdkField<Integer> MAX_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DeviceSelectionResult.getter(DeviceSelectionResult::maxDevices)).setter(DeviceSelectionResult.setter(Builder::maxDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDevices").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, MATCHED_DEVICES_COUNT_FIELD, MAX_DEVICES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DeviceFilter> filters;
    private final Integer matchedDevicesCount;
    private final Integer maxDevices;

    private DeviceSelectionResult(BuilderImpl builder) {
        this.filters = builder.filters;
        this.matchedDevicesCount = builder.matchedDevicesCount;
        this.maxDevices = builder.maxDevices;
    }

    public List<DeviceFilter> filters() {
        return this.filters;
    }

    public Integer matchedDevicesCount() {
        return this.matchedDevicesCount;
    }

    public Integer maxDevices() {
        return this.maxDevices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchedDevicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDevices());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSelectionResult)) {
            return false;
        }
        DeviceSelectionResult other = (DeviceSelectionResult)obj;
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.matchedDevicesCount(), other.matchedDevicesCount()) && Objects.equals(this.maxDevices(), other.maxDevices());
    }

    public String toString() {
        return ToString.builder((String)"DeviceSelectionResult").add("Filters", this.filters()).add("MatchedDevicesCount", (Object)this.matchedDevicesCount()).add("MaxDevices", (Object)this.maxDevices()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "matchedDevicesCount": {
                return Optional.ofNullable(clazz.cast(this.matchedDevicesCount()));
            }
            case "maxDevices": {
                return Optional.ofNullable(clazz.cast(this.maxDevices()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceSelectionResult, T> g) {
        return obj -> g.apply((DeviceSelectionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DeviceFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer matchedDevicesCount;
        private Integer maxDevices;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSelectionResult model) {
            this.filters(model.filters);
            this.matchedDevicesCount(model.matchedDevicesCount);
            this.maxDevices(model.maxDevices);
        }

        public final Collection<DeviceFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(DeviceFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<DeviceFilter> filters) {
            this.filters = DeviceFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DeviceFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DeviceFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (DeviceFilter)((DeviceFilter.Builder)DeviceFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<DeviceFilter.BuilderImpl> filters) {
            this.filters = DeviceFiltersCopier.copyFromBuilder(filters);
        }

        public final Integer getMatchedDevicesCount() {
            return this.matchedDevicesCount;
        }

        @Override
        public final Builder matchedDevicesCount(Integer matchedDevicesCount) {
            this.matchedDevicesCount = matchedDevicesCount;
            return this;
        }

        public final void setMatchedDevicesCount(Integer matchedDevicesCount) {
            this.matchedDevicesCount = matchedDevicesCount;
        }

        public final Integer getMaxDevices() {
            return this.maxDevices;
        }

        @Override
        public final Builder maxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
            return this;
        }

        public final void setMaxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
        }

        public DeviceSelectionResult build() {
            return new DeviceSelectionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceSelectionResult> {
        public Builder filters(Collection<DeviceFilter> var1);

        public Builder filters(DeviceFilter ... var1);

        public Builder filters(Consumer<DeviceFilter.Builder> ... var1);

        public Builder matchedDevicesCount(Integer var1);

        public Builder maxDevices(Integer var1);
    }
}

