/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.InstanceLabelsCopier;
import software.amazon.awssdk.services.devicefarm.model.InstanceProfile;
import software.amazon.awssdk.services.devicefarm.model.InstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceInstance> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceInstance.getter(DeviceInstance::arn)).setter(DeviceInstance.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceInstance.getter(DeviceInstance::deviceArn)).setter(DeviceInstance.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeviceInstance.getter(DeviceInstance::labels)).setter(DeviceInstance.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceInstance.getter(DeviceInstance::statusAsString)).setter(DeviceInstance.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> UDID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceInstance.getter(DeviceInstance::udid)).setter(DeviceInstance.setter(Builder::udid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udid").build()}).build();
    private static final SdkField<InstanceProfile> INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeviceInstance.getter(DeviceInstance::instanceProfile)).setter(DeviceInstance.setter(Builder::instanceProfile)).constructor(InstanceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceProfile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DEVICE_ARN_FIELD, LABELS_FIELD, STATUS_FIELD, UDID_FIELD, INSTANCE_PROFILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String deviceArn;
    private final List<String> labels;
    private final String status;
    private final String udid;
    private final InstanceProfile instanceProfile;

    private DeviceInstance(BuilderImpl builder) {
        this.arn = builder.arn;
        this.deviceArn = builder.deviceArn;
        this.labels = builder.labels;
        this.status = builder.status;
        this.udid = builder.udid;
        this.instanceProfile = builder.instanceProfile;
    }

    public String arn() {
        return this.arn;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public List<String> labels() {
        return this.labels;
    }

    public InstanceStatus status() {
        return InstanceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String udid() {
        return this.udid;
    }

    public InstanceProfile instanceProfile() {
        return this.instanceProfile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.udid());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfile());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceInstance)) {
            return false;
        }
        DeviceInstance other = (DeviceInstance)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.udid(), other.udid()) && Objects.equals(this.instanceProfile(), other.instanceProfile());
    }

    public String toString() {
        return ToString.builder((String)"DeviceInstance").add("Arn", (Object)this.arn()).add("DeviceArn", (Object)this.deviceArn()).add("Labels", this.labels()).add("Status", (Object)this.statusAsString()).add("Udid", (Object)this.udid()).add("InstanceProfile", (Object)this.instanceProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "udid": {
                return Optional.ofNullable(clazz.cast(this.udid()));
            }
            case "instanceProfile": {
                return Optional.ofNullable(clazz.cast(this.instanceProfile()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceInstance, T> g) {
        return obj -> g.apply((DeviceInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String deviceArn;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String udid;
        private InstanceProfile instanceProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceInstance model) {
            this.arn(model.arn);
            this.deviceArn(model.deviceArn);
            this.labels(model.labels);
            this.status(model.status);
            this.udid(model.udid);
            this.instanceProfile(model.instanceProfile);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = InstanceLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = InstanceLabelsCopier.copy(labels);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getUdid() {
            return this.udid;
        }

        @Override
        public final Builder udid(String udid) {
            this.udid = udid;
            return this;
        }

        public final void setUdid(String udid) {
            this.udid = udid;
        }

        public final InstanceProfile.Builder getInstanceProfile() {
            return this.instanceProfile != null ? this.instanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder instanceProfile(InstanceProfile instanceProfile) {
            this.instanceProfile = instanceProfile;
            return this;
        }

        public final void setInstanceProfile(InstanceProfile.BuilderImpl instanceProfile) {
            this.instanceProfile = instanceProfile != null ? instanceProfile.build() : null;
        }

        public DeviceInstance build() {
            return new DeviceInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceInstance> {
        public Builder arn(String var1);

        public Builder deviceArn(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder status(String var1);

        public Builder status(InstanceStatus var1);

        public Builder udid(String var1);

        public Builder instanceProfile(InstanceProfile var1);

        default public Builder instanceProfile(Consumer<InstanceProfile.Builder> instanceProfile) {
            return this.instanceProfile((InstanceProfile)((InstanceProfile.Builder)InstanceProfile.builder().applyMutation(instanceProfile)).build());
        }
    }
}

