/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblem;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblemsByExecutionResultMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUniqueProblemsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListUniqueProblemsResponse> {
    private static final SdkField<Map<String, List<UniqueProblem>>> UNIQUE_PROBLEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("uniqueProblems").getter(ListUniqueProblemsResponse.getter(ListUniqueProblemsResponse::uniqueProblemsAsStrings)).setter(ListUniqueProblemsResponse.setter(Builder::uniqueProblemsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueProblems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UniqueProblem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUniqueProblemsResponse.getter(ListUniqueProblemsResponse::nextToken)).setter(ListUniqueProblemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIQUE_PROBLEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUniqueProblemsResponse.memberNameToFieldInitializer();
    private final Map<String, List<UniqueProblem>> uniqueProblems;
    private final String nextToken;

    private ListUniqueProblemsResponse(BuilderImpl builder) {
        super(builder);
        this.uniqueProblems = builder.uniqueProblems;
        this.nextToken = builder.nextToken;
    }

    public final Map<ExecutionResult, List<UniqueProblem>> uniqueProblems() {
        return UniqueProblemsByExecutionResultMapCopier.copyStringToEnum(this.uniqueProblems);
    }

    public final boolean hasUniqueProblems() {
        return this.uniqueProblems != null && !(this.uniqueProblems instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<UniqueProblem>> uniqueProblemsAsStrings() {
        return this.uniqueProblems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUniqueProblems() ? this.uniqueProblemsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUniqueProblemsResponse)) {
            return false;
        }
        ListUniqueProblemsResponse other = (ListUniqueProblemsResponse)((Object)obj);
        return this.hasUniqueProblems() == other.hasUniqueProblems() && Objects.equals(this.uniqueProblemsAsStrings(), other.uniqueProblemsAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUniqueProblemsResponse").add("UniqueProblems", this.hasUniqueProblems() ? this.uniqueProblemsAsStrings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "uniqueProblems": {
                return Optional.ofNullable(clazz.cast(this.uniqueProblemsAsStrings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uniqueProblems", UNIQUE_PROBLEMS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUniqueProblemsResponse, T> g) {
        return obj -> g.apply((ListUniqueProblemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private Map<String, List<UniqueProblem>> uniqueProblems = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUniqueProblemsResponse model) {
            super(model);
            this.uniqueProblemsWithStrings(model.uniqueProblems);
            this.nextToken(model.nextToken);
        }

        public final Map<String, List<UniqueProblem.Builder>> getUniqueProblems() {
            Map<String, List<UniqueProblem.Builder>> result = UniqueProblemsByExecutionResultMapCopier.copyToBuilder(this.uniqueProblems);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUniqueProblems(Map<String, ? extends Collection<UniqueProblem.BuilderImpl>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copyFromBuilder(uniqueProblems);
        }

        @Override
        public final Builder uniqueProblemsWithStrings(Map<String, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copy(uniqueProblems);
            return this;
        }

        @Override
        public final Builder uniqueProblems(Map<ExecutionResult, ? extends Collection<UniqueProblem>> uniqueProblems) {
            this.uniqueProblems = UniqueProblemsByExecutionResultMapCopier.copyEnumToString(uniqueProblems);
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUniqueProblemsResponse build() {
            return new ListUniqueProblemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUniqueProblemsResponse> {
        public Builder uniqueProblemsWithStrings(Map<String, ? extends Collection<UniqueProblem>> var1);

        public Builder uniqueProblems(Map<ExecutionResult, ? extends Collection<UniqueProblem>> var1);

        public Builder nextToken(String var1);
    }
}

