/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceAttribute {
    ARN("ARN"),
    PLATFORM("PLATFORM"),
    FORM_FACTOR("FORM_FACTOR"),
    MANUFACTURER("MANUFACTURER"),
    REMOTE_ACCESS_ENABLED("REMOTE_ACCESS_ENABLED"),
    REMOTE_DEBUG_ENABLED("REMOTE_DEBUG_ENABLED"),
    APPIUM_VERSION("APPIUM_VERSION"),
    INSTANCE_ARN("INSTANCE_ARN"),
    INSTANCE_LABELS("INSTANCE_LABELS"),
    FLEET_TYPE("FLEET_TYPE"),
    OS_VERSION("OS_VERSION"),
    MODEL("MODEL"),
    AVAILABILITY("AVAILABILITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceAttribute> VALUE_MAP;
    private final String value;

    private DeviceAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceAttribute> knownValues() {
        EnumSet<DeviceAttribute> knownValues = EnumSet.allOf(DeviceAttribute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceAttribute.class, DeviceAttribute::toString);
    }
}

