/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessage;
import software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DevicePoolCompatibilityResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DevicePoolCompatibilityResult> {
    private static final SdkField<Device> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DevicePoolCompatibilityResult.getter(DevicePoolCompatibilityResult::device)).setter(DevicePoolCompatibilityResult.setter(Builder::device)).constructor(Device::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()}).build();
    private static final SdkField<Boolean> COMPATIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DevicePoolCompatibilityResult.getter(DevicePoolCompatibilityResult::compatible)).setter(DevicePoolCompatibilityResult.setter(Builder::compatible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatible").build()}).build();
    private static final SdkField<List<IncompatibilityMessage>> INCOMPATIBILITY_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DevicePoolCompatibilityResult.getter(DevicePoolCompatibilityResult::incompatibilityMessages)).setter(DevicePoolCompatibilityResult.setter(Builder::incompatibilityMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incompatibilityMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncompatibilityMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FIELD, COMPATIBLE_FIELD, INCOMPATIBILITY_MESSAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Device device;
    private final Boolean compatible;
    private final List<IncompatibilityMessage> incompatibilityMessages;

    private DevicePoolCompatibilityResult(BuilderImpl builder) {
        this.device = builder.device;
        this.compatible = builder.compatible;
        this.incompatibilityMessages = builder.incompatibilityMessages;
    }

    public Device device() {
        return this.device;
    }

    public Boolean compatible() {
        return this.compatible;
    }

    public List<IncompatibilityMessage> incompatibilityMessages() {
        return this.incompatibilityMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatible());
        hashCode = 31 * hashCode + Objects.hashCode(this.incompatibilityMessages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevicePoolCompatibilityResult)) {
            return false;
        }
        DevicePoolCompatibilityResult other = (DevicePoolCompatibilityResult)obj;
        return Objects.equals(this.device(), other.device()) && Objects.equals(this.compatible(), other.compatible()) && Objects.equals(this.incompatibilityMessages(), other.incompatibilityMessages());
    }

    public String toString() {
        return ToString.builder((String)"DevicePoolCompatibilityResult").add("Device", (Object)this.device()).add("Compatible", (Object)this.compatible()).add("IncompatibilityMessages", this.incompatibilityMessages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "compatible": {
                return Optional.ofNullable(clazz.cast(this.compatible()));
            }
            case "incompatibilityMessages": {
                return Optional.ofNullable(clazz.cast(this.incompatibilityMessages()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DevicePoolCompatibilityResult, T> g) {
        return obj -> g.apply((DevicePoolCompatibilityResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Device device;
        private Boolean compatible;
        private List<IncompatibilityMessage> incompatibilityMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DevicePoolCompatibilityResult model) {
            this.device(model.device);
            this.compatible(model.compatible);
            this.incompatibilityMessages(model.incompatibilityMessages);
        }

        public final Device.Builder getDevice() {
            return this.device != null ? this.device.toBuilder() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        public final Boolean getCompatible() {
            return this.compatible;
        }

        @Override
        public final Builder compatible(Boolean compatible) {
            this.compatible = compatible;
            return this;
        }

        public final void setCompatible(Boolean compatible) {
            this.compatible = compatible;
        }

        public final Collection<IncompatibilityMessage.Builder> getIncompatibilityMessages() {
            return this.incompatibilityMessages != null ? (Collection)this.incompatibilityMessages.stream().map(IncompatibilityMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder incompatibilityMessages(Collection<IncompatibilityMessage> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copy(incompatibilityMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibilityMessages(IncompatibilityMessage ... incompatibilityMessages) {
            this.incompatibilityMessages(Arrays.asList(incompatibilityMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibilityMessages(Consumer<IncompatibilityMessage.Builder> ... incompatibilityMessages) {
            this.incompatibilityMessages(Stream.of(incompatibilityMessages).map(c -> (IncompatibilityMessage)((IncompatibilityMessage.Builder)IncompatibilityMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIncompatibilityMessages(Collection<IncompatibilityMessage.BuilderImpl> incompatibilityMessages) {
            this.incompatibilityMessages = IncompatibilityMessagesCopier.copyFromBuilder(incompatibilityMessages);
        }

        public DevicePoolCompatibilityResult build() {
            return new DevicePoolCompatibilityResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DevicePoolCompatibilityResult> {
        public Builder device(Device var1);

        default public Builder device(Consumer<Device.Builder> device) {
            return this.device((Device)((Device.Builder)Device.builder().applyMutation(device)).build());
        }

        public Builder compatible(Boolean var1);

        public Builder incompatibilityMessages(Collection<IncompatibilityMessage> var1);

        public Builder incompatibilityMessages(IncompatibilityMessage ... var1);

        public Builder incompatibilityMessages(Consumer<IncompatibilityMessage.Builder> ... var1);
    }
}

