/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.model.DevicePlatform;
import software.amazon.awssdk.services.devicefarm.model.MaxSlotMapCopier;
import software.amazon.awssdk.services.devicefarm.model.PurchasedDevicesMapCopier;
import software.amazon.awssdk.services.devicefarm.model.TrialMinutes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountSettings> {
    private static final SdkField<String> AWS_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountNumber").getter(AccountSettings.getter(AccountSettings::awsAccountNumber)).setter(AccountSettings.setter(Builder::awsAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountNumber").build()}).build();
    private static final SdkField<Map<String, Integer>> UNMETERED_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("unmeteredDevices").getter(AccountSettings.getter(AccountSettings::unmeteredDevicesAsStrings)).setter(AccountSettings.setter(Builder::unmeteredDevicesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmeteredDevices").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> UNMETERED_REMOTE_ACCESS_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("unmeteredRemoteAccessDevices").getter(AccountSettings.getter(AccountSettings::unmeteredRemoteAccessDevicesAsStrings)).setter(AccountSettings.setter(Builder::unmeteredRemoteAccessDevicesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmeteredRemoteAccessDevices").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_JOB_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxJobTimeoutMinutes").getter(AccountSettings.getter(AccountSettings::maxJobTimeoutMinutes)).setter(AccountSettings.setter(Builder::maxJobTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobTimeoutMinutes").build()}).build();
    private static final SdkField<TrialMinutes> TRIAL_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trialMinutes").getter(AccountSettings.getter(AccountSettings::trialMinutes)).setter(AccountSettings.setter(Builder::trialMinutes)).constructor(TrialMinutes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trialMinutes").build()}).build();
    private static final SdkField<Map<String, Integer>> MAX_SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("maxSlots").getter(AccountSettings.getter(AccountSettings::maxSlots)).setter(AccountSettings.setter(Builder::maxSlots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSlots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> DEFAULT_JOB_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("defaultJobTimeoutMinutes").getter(AccountSettings.getter(AccountSettings::defaultJobTimeoutMinutes)).setter(AccountSettings.setter(Builder::defaultJobTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultJobTimeoutMinutes").build()}).build();
    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipAppResign").getter(AccountSettings.getter(AccountSettings::skipAppResign)).setter(AccountSettings.setter(Builder::skipAppResign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_NUMBER_FIELD, UNMETERED_DEVICES_FIELD, UNMETERED_REMOTE_ACCESS_DEVICES_FIELD, MAX_JOB_TIMEOUT_MINUTES_FIELD, TRIAL_MINUTES_FIELD, MAX_SLOTS_FIELD, DEFAULT_JOB_TIMEOUT_MINUTES_FIELD, SKIP_APP_RESIGN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("awsAccountNumber", AWS_ACCOUNT_NUMBER_FIELD);
            this.put("unmeteredDevices", UNMETERED_DEVICES_FIELD);
            this.put("unmeteredRemoteAccessDevices", UNMETERED_REMOTE_ACCESS_DEVICES_FIELD);
            this.put("maxJobTimeoutMinutes", MAX_JOB_TIMEOUT_MINUTES_FIELD);
            this.put("trialMinutes", TRIAL_MINUTES_FIELD);
            this.put("maxSlots", MAX_SLOTS_FIELD);
            this.put("defaultJobTimeoutMinutes", DEFAULT_JOB_TIMEOUT_MINUTES_FIELD);
            this.put("skipAppResign", SKIP_APP_RESIGN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String awsAccountNumber;
    private final Map<String, Integer> unmeteredDevices;
    private final Map<String, Integer> unmeteredRemoteAccessDevices;
    private final Integer maxJobTimeoutMinutes;
    private final TrialMinutes trialMinutes;
    private final Map<String, Integer> maxSlots;
    private final Integer defaultJobTimeoutMinutes;
    private final Boolean skipAppResign;

    private AccountSettings(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.unmeteredDevices = builder.unmeteredDevices;
        this.unmeteredRemoteAccessDevices = builder.unmeteredRemoteAccessDevices;
        this.maxJobTimeoutMinutes = builder.maxJobTimeoutMinutes;
        this.trialMinutes = builder.trialMinutes;
        this.maxSlots = builder.maxSlots;
        this.defaultJobTimeoutMinutes = builder.defaultJobTimeoutMinutes;
        this.skipAppResign = builder.skipAppResign;
    }

    public final String awsAccountNumber() {
        return this.awsAccountNumber;
    }

    public final Map<DevicePlatform, Integer> unmeteredDevices() {
        return PurchasedDevicesMapCopier.copyStringToEnum(this.unmeteredDevices);
    }

    public final boolean hasUnmeteredDevices() {
        return this.unmeteredDevices != null && !(this.unmeteredDevices instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> unmeteredDevicesAsStrings() {
        return this.unmeteredDevices;
    }

    public final Map<DevicePlatform, Integer> unmeteredRemoteAccessDevices() {
        return PurchasedDevicesMapCopier.copyStringToEnum(this.unmeteredRemoteAccessDevices);
    }

    public final boolean hasUnmeteredRemoteAccessDevices() {
        return this.unmeteredRemoteAccessDevices != null && !(this.unmeteredRemoteAccessDevices instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> unmeteredRemoteAccessDevicesAsStrings() {
        return this.unmeteredRemoteAccessDevices;
    }

    public final Integer maxJobTimeoutMinutes() {
        return this.maxJobTimeoutMinutes;
    }

    public final TrialMinutes trialMinutes() {
        return this.trialMinutes;
    }

    public final boolean hasMaxSlots() {
        return this.maxSlots != null && !(this.maxSlots instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> maxSlots() {
        return this.maxSlots;
    }

    public final Integer defaultJobTimeoutMinutes() {
        return this.defaultJobTimeoutMinutes;
    }

    public final Boolean skipAppResign() {
        return this.skipAppResign;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnmeteredDevices() ? this.unmeteredDevicesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnmeteredRemoteAccessDevices() ? this.unmeteredRemoteAccessDevicesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxJobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMaxSlots() ? this.maxSlots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultJobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipAppResign());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings)obj;
        return Objects.equals(this.awsAccountNumber(), other.awsAccountNumber()) && this.hasUnmeteredDevices() == other.hasUnmeteredDevices() && Objects.equals(this.unmeteredDevicesAsStrings(), other.unmeteredDevicesAsStrings()) && this.hasUnmeteredRemoteAccessDevices() == other.hasUnmeteredRemoteAccessDevices() && Objects.equals(this.unmeteredRemoteAccessDevicesAsStrings(), other.unmeteredRemoteAccessDevicesAsStrings()) && Objects.equals(this.maxJobTimeoutMinutes(), other.maxJobTimeoutMinutes()) && Objects.equals(this.trialMinutes(), other.trialMinutes()) && this.hasMaxSlots() == other.hasMaxSlots() && Objects.equals(this.maxSlots(), other.maxSlots()) && Objects.equals(this.defaultJobTimeoutMinutes(), other.defaultJobTimeoutMinutes()) && Objects.equals(this.skipAppResign(), other.skipAppResign());
    }

    public final String toString() {
        return ToString.builder((String)"AccountSettings").add("AwsAccountNumber", (Object)this.awsAccountNumber()).add("UnmeteredDevices", this.hasUnmeteredDevices() ? this.unmeteredDevicesAsStrings() : null).add("UnmeteredRemoteAccessDevices", this.hasUnmeteredRemoteAccessDevices() ? this.unmeteredRemoteAccessDevicesAsStrings() : null).add("MaxJobTimeoutMinutes", (Object)this.maxJobTimeoutMinutes()).add("TrialMinutes", (Object)this.trialMinutes()).add("MaxSlots", this.hasMaxSlots() ? this.maxSlots() : null).add("DefaultJobTimeoutMinutes", (Object)this.defaultJobTimeoutMinutes()).add("SkipAppResign", (Object)this.skipAppResign()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.awsAccountNumber()));
            }
            case "unmeteredDevices": {
                return Optional.ofNullable(clazz.cast(this.unmeteredDevicesAsStrings()));
            }
            case "unmeteredRemoteAccessDevices": {
                return Optional.ofNullable(clazz.cast(this.unmeteredRemoteAccessDevicesAsStrings()));
            }
            case "maxJobTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.maxJobTimeoutMinutes()));
            }
            case "trialMinutes": {
                return Optional.ofNullable(clazz.cast(this.trialMinutes()));
            }
            case "maxSlots": {
                return Optional.ofNullable(clazz.cast(this.maxSlots()));
            }
            case "defaultJobTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.defaultJobTimeoutMinutes()));
            }
            case "skipAppResign": {
                return Optional.ofNullable(clazz.cast(this.skipAppResign()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountNumber;
        private Map<String, Integer> unmeteredDevices = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Integer> unmeteredRemoteAccessDevices = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxJobTimeoutMinutes;
        private TrialMinutes trialMinutes;
        private Map<String, Integer> maxSlots = DefaultSdkAutoConstructMap.getInstance();
        private Integer defaultJobTimeoutMinutes;
        private Boolean skipAppResign;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            this.awsAccountNumber(model.awsAccountNumber);
            this.unmeteredDevicesWithStrings(model.unmeteredDevices);
            this.unmeteredRemoteAccessDevicesWithStrings(model.unmeteredRemoteAccessDevices);
            this.maxJobTimeoutMinutes(model.maxJobTimeoutMinutes);
            this.trialMinutes(model.trialMinutes);
            this.maxSlots(model.maxSlots);
            this.defaultJobTimeoutMinutes(model.defaultJobTimeoutMinutes);
            this.skipAppResign(model.skipAppResign);
        }

        public final String getAwsAccountNumber() {
            return this.awsAccountNumber;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        @Override
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final Map<String, Integer> getUnmeteredDevices() {
            if (this.unmeteredDevices instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.unmeteredDevices;
        }

        public final void setUnmeteredDevices(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
        }

        @Override
        public final Builder unmeteredDevicesWithStrings(Map<String, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copy(unmeteredDevices);
            return this;
        }

        @Override
        public final Builder unmeteredDevices(Map<DevicePlatform, Integer> unmeteredDevices) {
            this.unmeteredDevices = PurchasedDevicesMapCopier.copyEnumToString(unmeteredDevices);
            return this;
        }

        public final Map<String, Integer> getUnmeteredRemoteAccessDevices() {
            if (this.unmeteredRemoteAccessDevices instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.unmeteredRemoteAccessDevices;
        }

        public final void setUnmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
        }

        @Override
        public final Builder unmeteredRemoteAccessDevicesWithStrings(Map<String, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copy(unmeteredRemoteAccessDevices);
            return this;
        }

        @Override
        public final Builder unmeteredRemoteAccessDevices(Map<DevicePlatform, Integer> unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = PurchasedDevicesMapCopier.copyEnumToString(unmeteredRemoteAccessDevices);
            return this;
        }

        public final Integer getMaxJobTimeoutMinutes() {
            return this.maxJobTimeoutMinutes;
        }

        public final void setMaxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
        }

        @Override
        public final Builder maxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
            this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
            return this;
        }

        public final TrialMinutes.Builder getTrialMinutes() {
            return this.trialMinutes != null ? this.trialMinutes.toBuilder() : null;
        }

        public final void setTrialMinutes(TrialMinutes.BuilderImpl trialMinutes) {
            this.trialMinutes = trialMinutes != null ? trialMinutes.build() : null;
        }

        @Override
        public final Builder trialMinutes(TrialMinutes trialMinutes) {
            this.trialMinutes = trialMinutes;
            return this;
        }

        public final Map<String, Integer> getMaxSlots() {
            if (this.maxSlots instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.maxSlots;
        }

        public final void setMaxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
        }

        @Override
        public final Builder maxSlots(Map<String, Integer> maxSlots) {
            this.maxSlots = MaxSlotMapCopier.copy(maxSlots);
            return this;
        }

        public final Integer getDefaultJobTimeoutMinutes() {
            return this.defaultJobTimeoutMinutes;
        }

        public final void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
        }

        @Override
        public final Builder defaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
            this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
            return this;
        }

        public final Boolean getSkipAppResign() {
            return this.skipAppResign;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        @Override
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        public AccountSettings build() {
            return new AccountSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountSettings> {
        public Builder awsAccountNumber(String var1);

        public Builder unmeteredDevicesWithStrings(Map<String, Integer> var1);

        public Builder unmeteredDevices(Map<DevicePlatform, Integer> var1);

        public Builder unmeteredRemoteAccessDevicesWithStrings(Map<String, Integer> var1);

        public Builder unmeteredRemoteAccessDevices(Map<DevicePlatform, Integer> var1);

        public Builder maxJobTimeoutMinutes(Integer var1);

        public Builder trialMinutes(TrialMinutes var1);

        default public Builder trialMinutes(Consumer<TrialMinutes.Builder> trialMinutes) {
            return this.trialMinutes((TrialMinutes)((TrialMinutes.Builder)TrialMinutes.builder().applyMutation(trialMinutes)).build());
        }

        public Builder maxSlots(Map<String, Integer> var1);

        public Builder defaultJobTimeoutMinutes(Integer var1);

        public Builder skipAppResign(Boolean var1);
    }
}

