/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.internal.UserAgentUtils;
import software.amazon.awssdk.services.devicefarm.model.DevicePool;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse;

public class ListDevicePoolsPublisher
implements SdkPublisher<ListDevicePoolsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListDevicePoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDevicePoolsPublisher(DeviceFarmAsyncClient client, ListDevicePoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDevicePoolsPublisher(DeviceFarmAsyncClient client, ListDevicePoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDevicePoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDevicePoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DevicePool> devicePools() {
        Function<ListDevicePoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.devicePools() != null) {
                return response.devicePools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDevicePoolsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDevicePoolsResponseFetcher
    implements AsyncPageFetcher<ListDevicePoolsResponse> {
        private ListDevicePoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicePoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDevicePoolsResponse> nextPage(ListDevicePoolsResponse previousPage) {
            if (previousPage == null) {
                return ListDevicePoolsPublisher.this.client.listDevicePools(ListDevicePoolsPublisher.this.firstRequest);
            }
            return ListDevicePoolsPublisher.this.client.listDevicePools((ListDevicePoolsRequest)((Object)ListDevicePoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

