/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExecutionResultCode {
    PARSING_FAILED("PARSING_FAILED"),
    VPC_ENDPOINT_SETUP_FAILED("VPC_ENDPOINT_SETUP_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionResultCode> VALUE_MAP;
    private final String value;

    private ExecutionResultCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionResultCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionResultCode> knownValues() {
        EnumSet<ExecutionResultCode> knownValues = EnumSet.allOf(ExecutionResultCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExecutionResultCode.class, ExecutionResultCode::toString);
    }
}

