/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Artifacts are video and other files that are produced in the process of running a browser in an automated context.
 * </p>
 * <note>
 * <p>
 * Video elements might be broken up into multiple artifacts as they grow in size during creation.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestGridSessionArtifact implements SdkPojo, Serializable,
        ToCopyableBuilder<TestGridSessionArtifact.Builder, TestGridSessionArtifact> {
    private static final SdkField<String> FILENAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filename").getter(getter(TestGridSessionArtifact::filename)).setter(setter(Builder::filename))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filename").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(TestGridSessionArtifact::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(TestGridSessionArtifact::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILENAME_FIELD, TYPE_FIELD,
            URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filename;

    private final String type;

    private final String url;

    private TestGridSessionArtifact(BuilderImpl builder) {
        this.filename = builder.filename;
        this.type = builder.type;
        this.url = builder.url;
    }

    /**
     * <p>
     * The file name of the artifact.
     * </p>
     * 
     * @return The file name of the artifact.
     */
    public final String filename() {
        return filename;
    }

    /**
     * <p>
     * The kind of artifact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestGridSessionArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of artifact.
     * @see TestGridSessionArtifactType
     */
    public final TestGridSessionArtifactType type() {
        return TestGridSessionArtifactType.fromValue(type);
    }

    /**
     * <p>
     * The kind of artifact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestGridSessionArtifactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The kind of artifact.
     * @see TestGridSessionArtifactType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A semi-stable URL to the content of the object.
     * </p>
     * 
     * @return A semi-stable URL to the content of the object.
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filename());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestGridSessionArtifact)) {
            return false;
        }
        TestGridSessionArtifact other = (TestGridSessionArtifact) obj;
        return Objects.equals(filename(), other.filename()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestGridSessionArtifact").add("Filename", filename()).add("Type", typeAsString())
                .add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filename":
            return Optional.ofNullable(clazz.cast(filename()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestGridSessionArtifact, T> g) {
        return obj -> g.apply((TestGridSessionArtifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestGridSessionArtifact> {
        /**
         * <p>
         * The file name of the artifact.
         * </p>
         * 
         * @param filename
         *        The file name of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filename(String filename);

        /**
         * <p>
         * The kind of artifact.
         * </p>
         * 
         * @param type
         *        The kind of artifact.
         * @see TestGridSessionArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestGridSessionArtifactType
         */
        Builder type(String type);

        /**
         * <p>
         * The kind of artifact.
         * </p>
         * 
         * @param type
         *        The kind of artifact.
         * @see TestGridSessionArtifactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestGridSessionArtifactType
         */
        Builder type(TestGridSessionArtifactType type);

        /**
         * <p>
         * A semi-stable URL to the content of the object.
         * </p>
         * 
         * @param url
         *        A semi-stable URL to the content of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String filename;

        private String type;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(TestGridSessionArtifact model) {
            filename(model.filename);
            type(model.type);
            url(model.url);
        }

        public final String getFilename() {
            return filename;
        }

        @Override
        public final Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public final void setFilename(String filename) {
            this.filename = filename;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestGridSessionArtifactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public TestGridSessionArtifact build() {
            return new TestGridSessionArtifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
