/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestGridSessionActionsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListTestGridSessionActionsResponse.Builder, ListTestGridSessionActionsResponse> {
    private static final SdkField<List<TestGridSessionAction>> ACTIONS_FIELD = SdkField
            .<List<TestGridSessionAction>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(ListTestGridSessionActionsResponse::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestGridSessionAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestGridSessionAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestGridSessionActionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TestGridSessionAction> actions;

    private final String nextToken;

    private ListTestGridSessionActionsResponse(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action taken by the session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The action taken by the session.
     */
    public final List<TestGridSessionAction> actions() {
        return actions;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridSessionActionsResponse)) {
            return false;
        }
        ListTestGridSessionActionsResponse other = (ListTestGridSessionActionsResponse) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestGridSessionActionsResponse").add("Actions", hasActions() ? actions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridSessionActionsResponse, T> g) {
        return obj -> g.apply((ListTestGridSessionActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTestGridSessionActionsResponse> {
        /**
         * <p>
         * The action taken by the session.
         * </p>
         * 
         * @param actions
         *        The action taken by the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<TestGridSessionAction> actions);

        /**
         * <p>
         * The action taken by the session.
         * </p>
         * 
         * @param actions
         *        The action taken by the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(TestGridSessionAction... actions);

        /**
         * <p>
         * The action taken by the session.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TestGridSessionAction>.Builder} avoiding
         * the need to create one manually via {@link List<TestGridSessionAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TestGridSessionAction>.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<TestGridSessionAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<TestGridSessionAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<TestGridSessionAction>)
         */
        Builder actions(Consumer<TestGridSessionAction.Builder>... actions);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<TestGridSessionAction> actions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridSessionActionsResponse model) {
            super(model);
            actions(model.actions);
            nextToken(model.nextToken);
        }

        public final Collection<TestGridSessionAction.Builder> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions != null ? actions.stream().map(TestGridSessionAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<TestGridSessionAction> actions) {
            this.actions = TestGridSessionActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(TestGridSessionAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<TestGridSessionAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> TestGridSessionAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<TestGridSessionAction.BuilderImpl> actions) {
            this.actions = TestGridSessionActionsCopier.copyFromBuilder(actions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestGridSessionActionsResponse build() {
            return new ListTestGridSessionActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
