/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestGridProjectsResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<ListTestGridProjectsResponse.Builder, ListTestGridProjectsResponse> {
    private static final SdkField<List<TestGridProject>> TEST_GRID_PROJECTS_FIELD = SdkField
            .<List<TestGridProject>> builder(MarshallingType.LIST)
            .memberName("testGridProjects")
            .getter(getter(ListTestGridProjectsResponse::testGridProjects))
            .setter(setter(Builder::testGridProjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testGridProjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestGridProject> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestGridProject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestGridProjectsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_GRID_PROJECTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TestGridProject> testGridProjects;

    private final String nextToken;

    private ListTestGridProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.testGridProjects = builder.testGridProjects;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the TestGridProjects property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTestGridProjects() {
        return testGridProjects != null && !(testGridProjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTestGridProjects()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.
     */
    public final List<TestGridProject> testGridProjects() {
        return testGridProjects;
    }

    /**
     * <p>
     * Used for pagination. Pass into <a>ListTestGridProjects</a> to get more results in a paginated request.
     * </p>
     * 
     * @return Used for pagination. Pass into <a>ListTestGridProjects</a> to get more results in a paginated request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTestGridProjects() ? testGridProjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridProjectsResponse)) {
            return false;
        }
        ListTestGridProjectsResponse other = (ListTestGridProjectsResponse) obj;
        return hasTestGridProjects() == other.hasTestGridProjects()
                && Objects.equals(testGridProjects(), other.testGridProjects()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestGridProjectsResponse")
                .add("TestGridProjects", hasTestGridProjects() ? testGridProjects() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testGridProjects":
            return Optional.ofNullable(clazz.cast(testGridProjects()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridProjectsResponse, T> g) {
        return obj -> g.apply((ListTestGridProjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTestGridProjectsResponse> {
        /**
         * <p>
         * The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.
         * </p>
         * 
         * @param testGridProjects
         *        The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testGridProjects(Collection<TestGridProject> testGridProjects);

        /**
         * <p>
         * The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.
         * </p>
         * 
         * @param testGridProjects
         *        The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testGridProjects(TestGridProject... testGridProjects);

        /**
         * <p>
         * The list of TestGridProjects, based on a <a>ListTestGridProjectsRequest</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TestGridProject>.Builder} avoiding the need
         * to create one manually via {@link List<TestGridProject>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TestGridProject>.Builder#build()} is called immediately and
         * its result is passed to {@link #testGridProjects(List<TestGridProject>)}.
         * 
         * @param testGridProjects
         *        a consumer that will call methods on {@link List<TestGridProject>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testGridProjects(List<TestGridProject>)
         */
        Builder testGridProjects(Consumer<TestGridProject.Builder>... testGridProjects);

        /**
         * <p>
         * Used for pagination. Pass into <a>ListTestGridProjects</a> to get more results in a paginated request.
         * </p>
         * 
         * @param nextToken
         *        Used for pagination. Pass into <a>ListTestGridProjects</a> to get more results in a paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private List<TestGridProject> testGridProjects = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridProjectsResponse model) {
            super(model);
            testGridProjects(model.testGridProjects);
            nextToken(model.nextToken);
        }

        public final Collection<TestGridProject.Builder> getTestGridProjects() {
            if (testGridProjects instanceof SdkAutoConstructList) {
                return null;
            }
            return testGridProjects != null ? testGridProjects.stream().map(TestGridProject::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder testGridProjects(Collection<TestGridProject> testGridProjects) {
            this.testGridProjects = TestGridProjectsCopier.copy(testGridProjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testGridProjects(TestGridProject... testGridProjects) {
            testGridProjects(Arrays.asList(testGridProjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testGridProjects(Consumer<TestGridProject.Builder>... testGridProjects) {
            testGridProjects(Stream.of(testGridProjects).map(c -> TestGridProject.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTestGridProjects(Collection<TestGridProject.BuilderImpl> testGridProjects) {
            this.testGridProjects = TestGridProjectsCopier.copyFromBuilder(testGridProjects);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestGridProjectsResponse build() {
            return new ListTestGridProjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
