/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse;
import software.amazon.awssdk.services.devicefarm.model.Sample;

public class ListSamplesPublisher
implements SdkPublisher<ListSamplesResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListSamplesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSamplesPublisher(DeviceFarmAsyncClient client, ListSamplesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSamplesPublisher(DeviceFarmAsyncClient client, ListSamplesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSamplesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSamplesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Sample> samples() {
        Function<ListSamplesResponse, Iterator> getIterator = response -> {
            if (response != null && response.samples() != null) {
                return response.samples().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSamplesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSamplesResponseFetcher
    implements AsyncPageFetcher<ListSamplesResponse> {
        private ListSamplesResponseFetcher() {
        }

        public boolean hasNextPage(ListSamplesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSamplesResponse> nextPage(ListSamplesResponse previousPage) {
            if (previousPage == null) {
                return ListSamplesPublisher.this.client.listSamples(ListSamplesPublisher.this.firstRequest);
            }
            return ListSamplesPublisher.this.client.listSamples((ListSamplesRequest)((Object)ListSamplesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

