/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.Upload;
import software.amazon.awssdk.services.devicefarm.model.UploadsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUploadsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListUploadsResponse> {
    private static final SdkField<List<Upload>> UPLOADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListUploadsResponse.getter(ListUploadsResponse::uploads)).setter(ListUploadsResponse.setter(Builder::uploads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploads").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Upload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListUploadsResponse.getter(ListUploadsResponse::nextToken)).setter(ListUploadsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOADS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Upload> uploads;
    private final String nextToken;

    private ListUploadsResponse(BuilderImpl builder) {
        super(builder);
        this.uploads = builder.uploads;
        this.nextToken = builder.nextToken;
    }

    public List<Upload> uploads() {
        return this.uploads;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.uploads());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUploadsResponse)) {
            return false;
        }
        ListUploadsResponse other = (ListUploadsResponse)((Object)obj);
        return Objects.equals(this.uploads(), other.uploads()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListUploadsResponse").add("Uploads", this.uploads()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "uploads": {
                return Optional.ofNullable(clazz.cast(this.uploads()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUploadsResponse, T> g) {
        return obj -> g.apply((ListUploadsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Upload> uploads = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUploadsResponse model) {
            super(model);
            this.uploads(model.uploads);
            this.nextToken(model.nextToken);
        }

        public final Collection<Upload.Builder> getUploads() {
            return this.uploads != null ? (Collection)this.uploads.stream().map(Upload::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder uploads(Collection<Upload> uploads) {
            this.uploads = UploadsCopier.copy(uploads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(Upload ... uploads) {
            this.uploads(Arrays.asList(uploads));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploads(Consumer<Upload.Builder> ... uploads) {
            this.uploads(Stream.of(uploads).map(c -> (Upload)((Upload.Builder)Upload.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUploads(Collection<Upload.BuilderImpl> uploads) {
            this.uploads = UploadsCopier.copyFromBuilder(uploads);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUploadsResponse build() {
            return new ListUploadsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUploadsResponse> {
        public Builder uploads(Collection<Upload> var1);

        public Builder uploads(Upload ... var1);

        public Builder uploads(Consumer<Upload.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

