/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueRequest;
import software.amazon.awssdk.services.deadline.model.ListStorageProfilesForQueueResponse;
import software.amazon.awssdk.services.deadline.model.StorageProfileSummary;

public class ListStorageProfilesForQueuePublisher
implements SdkPublisher<ListStorageProfilesForQueueResponse> {
    private final DeadlineAsyncClient client;
    private final ListStorageProfilesForQueueRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStorageProfilesForQueuePublisher(DeadlineAsyncClient client, ListStorageProfilesForQueueRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStorageProfilesForQueuePublisher(DeadlineAsyncClient client, ListStorageProfilesForQueueRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStorageProfilesForQueueResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStorageProfilesForQueueResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StorageProfileSummary> storageProfiles() {
        Function<ListStorageProfilesForQueueResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageProfiles() != null) {
                return response.storageProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStorageProfilesForQueueResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStorageProfilesForQueueResponseFetcher
    implements AsyncPageFetcher<ListStorageProfilesForQueueResponse> {
        private ListStorageProfilesForQueueResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageProfilesForQueueResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStorageProfilesForQueueResponse> nextPage(ListStorageProfilesForQueueResponse previousPage) {
            if (previousPage == null) {
                return ListStorageProfilesForQueuePublisher.this.client.listStorageProfilesForQueue(ListStorageProfilesForQueuePublisher.this.firstRequest);
            }
            return ListStorageProfilesForQueuePublisher.this.client.listStorageProfilesForQueue((ListStorageProfilesForQueueRequest)((Object)ListStorageProfilesForQueuePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

