/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueFleetAssociationsResponse;
import software.amazon.awssdk.services.deadline.model.QueueFleetAssociationSummary;

public class ListQueueFleetAssociationsIterable
implements SdkIterable<ListQueueFleetAssociationsResponse> {
    private final DeadlineClient client;
    private final ListQueueFleetAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueueFleetAssociationsIterable(DeadlineClient client, ListQueueFleetAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQueueFleetAssociationsResponseFetcher();
    }

    public Iterator<ListQueueFleetAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QueueFleetAssociationSummary> queueFleetAssociations() {
        Function<ListQueueFleetAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.queueFleetAssociations() != null) {
                return response.queueFleetAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQueueFleetAssociationsResponseFetcher
    implements SyncPageFetcher<ListQueueFleetAssociationsResponse> {
        private ListQueueFleetAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueFleetAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueueFleetAssociationsResponse nextPage(ListQueueFleetAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListQueueFleetAssociationsIterable.this.client.listQueueFleetAssociations(ListQueueFleetAssociationsIterable.this.firstRequest);
            }
            return ListQueueFleetAssociationsIterable.this.client.listQueueFleetAssociations((ListQueueFleetAssociationsRequest)((Object)ListQueueFleetAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

