/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaskRunStatus {
    PENDING("PENDING"),
    READY("READY"),
    ASSIGNED("ASSIGNED"),
    STARTING("STARTING"),
    SCHEDULED("SCHEDULED"),
    INTERRUPTING("INTERRUPTING"),
    RUNNING("RUNNING"),
    SUSPENDED("SUSPENDED"),
    CANCELED("CANCELED"),
    FAILED("FAILED"),
    SUCCEEDED("SUCCEEDED"),
    NOT_COMPATIBLE("NOT_COMPATIBLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaskRunStatus> VALUE_MAP;
    private final String value;

    private TaskRunStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskRunStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskRunStatus> knownValues() {
        EnumSet<TaskRunStatus> knownValues = EnumSet.allOf(TaskRunStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaskRunStatus.class, TaskRunStatus::toString);
    }
}

