/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.WorkerSummariesCopier;
import software.amazon.awssdk.services.deadline.model.WorkerSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkersResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListWorkersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkersResponse.getter(ListWorkersResponse::nextToken)).setter(ListWorkersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<WorkerSummary>> WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workers").getter(ListWorkersResponse.getter(ListWorkersResponse::workers)).setter(ListWorkersResponse.setter(Builder::workers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<WorkerSummary> workers;

    private ListWorkersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workers = builder.workers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkers() {
        return this.workers != null && !(this.workers instanceof SdkAutoConstructList);
    }

    public final List<WorkerSummary> workers() {
        return this.workers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkers() ? this.workers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkersResponse)) {
            return false;
        }
        ListWorkersResponse other = (ListWorkersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkers() == other.hasWorkers() && Objects.equals(this.workers(), other.workers());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkersResponse").add("NextToken", (Object)this.nextToken()).add("Workers", this.hasWorkers() ? this.workers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workers": {
                return Optional.ofNullable(clazz.cast(this.workers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("workers", WORKERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkersResponse, T> g) {
        return obj -> g.apply((ListWorkersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkerSummary> workers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workers(model.workers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkerSummary.Builder> getWorkers() {
            List<WorkerSummary.Builder> result = WorkerSummariesCopier.copyToBuilder(this.workers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkers(Collection<WorkerSummary.BuilderImpl> workers) {
            this.workers = WorkerSummariesCopier.copyFromBuilder(workers);
        }

        @Override
        public final Builder workers(Collection<WorkerSummary> workers) {
            this.workers = WorkerSummariesCopier.copy(workers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workers(WorkerSummary ... workers) {
            this.workers(Arrays.asList(workers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workers(Consumer<WorkerSummary.Builder> ... workers) {
            this.workers(Stream.of(workers).map(c -> (WorkerSummary)((WorkerSummary.Builder)WorkerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkersResponse build() {
            return new ListWorkersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkersResponse> {
        public Builder nextToken(String var1);

        public Builder workers(Collection<WorkerSummary> var1);

        public Builder workers(WorkerSummary ... var1);

        public Builder workers(Consumer<WorkerSummary.Builder> ... var1);
    }
}

