/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsRequest;
import software.amazon.awssdk.services.deadline.model.ListMeteredProductsResponse;
import software.amazon.awssdk.services.deadline.model.MeteredProductSummary;

public class ListMeteredProductsPublisher
implements SdkPublisher<ListMeteredProductsResponse> {
    private final DeadlineAsyncClient client;
    private final ListMeteredProductsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMeteredProductsPublisher(DeadlineAsyncClient client, ListMeteredProductsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMeteredProductsPublisher(DeadlineAsyncClient client, ListMeteredProductsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMeteredProductsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMeteredProductsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MeteredProductSummary> meteredProducts() {
        Function<ListMeteredProductsResponse, Iterator> getIterator = response -> {
            if (response != null && response.meteredProducts() != null) {
                return response.meteredProducts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMeteredProductsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMeteredProductsResponseFetcher
    implements AsyncPageFetcher<ListMeteredProductsResponse> {
        private ListMeteredProductsResponseFetcher() {
        }

        public boolean hasNextPage(ListMeteredProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMeteredProductsResponse> nextPage(ListMeteredProductsResponse previousPage) {
            if (previousPage == null) {
                return ListMeteredProductsPublisher.this.client.listMeteredProducts(ListMeteredProductsPublisher.this.firstRequest);
            }
            return ListMeteredProductsPublisher.this.client.listMeteredProducts((ListMeteredProductsRequest)((Object)ListMeteredProductsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

