/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.HostPropertiesResponse;
import software.amazon.awssdk.services.deadline.model.LogConfiguration;
import software.amazon.awssdk.services.deadline.model.SessionLifecycleStatus;
import software.amazon.awssdk.services.deadline.model.SessionLifecycleTargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, GetSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetSessionResponse.getter(GetSessionResponse::sessionId)).setter(GetSessionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetId").getter(GetSessionResponse.getter(GetSessionResponse::fleetId)).setter(GetSessionResponse.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()}).build();
    private static final SdkField<String> WORKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerId").getter(GetSessionResponse.getter(GetSessionResponse::workerId)).setter(GetSessionResponse.setter(Builder::workerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerId").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetSessionResponse.getter(GetSessionResponse::startedAt)).setter(GetSessionResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<LogConfiguration> LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("log").getter(GetSessionResponse.getter(GetSessionResponse::log)).setter(GetSessionResponse.setter(Builder::log)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatus").getter(GetSessionResponse.getter(GetSessionResponse::lifecycleStatusAsString)).setter(GetSessionResponse.setter(Builder::lifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(GetSessionResponse.getter(GetSessionResponse::endedAt)).setter(GetSessionResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetSessionResponse.getter(GetSessionResponse::updatedAt)).setter(GetSessionResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(GetSessionResponse.getter(GetSessionResponse::updatedBy)).setter(GetSessionResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<String> TARGET_LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetLifecycleStatus").getter(GetSessionResponse.getter(GetSessionResponse::targetLifecycleStatusAsString)).setter(GetSessionResponse.setter(Builder::targetLifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLifecycleStatus").build()}).build();
    private static final SdkField<HostPropertiesResponse> HOST_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hostProperties").getter(GetSessionResponse.getter(GetSessionResponse::hostProperties)).setter(GetSessionResponse.setter(Builder::hostProperties)).constructor(HostPropertiesResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostProperties").build()}).build();
    private static final SdkField<LogConfiguration> WORKER_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workerLog").getter(GetSessionResponse.getter(GetSessionResponse::workerLog)).setter(GetSessionResponse.setter(Builder::workerLog)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerLog").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, FLEET_ID_FIELD, WORKER_ID_FIELD, STARTED_AT_FIELD, LOG_FIELD, LIFECYCLE_STATUS_FIELD, ENDED_AT_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, TARGET_LIFECYCLE_STATUS_FIELD, HOST_PROPERTIES_FIELD, WORKER_LOG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSessionResponse.memberNameToFieldInitializer();
    private final String sessionId;
    private final String fleetId;
    private final String workerId;
    private final Instant startedAt;
    private final LogConfiguration log;
    private final String lifecycleStatus;
    private final Instant endedAt;
    private final Instant updatedAt;
    private final String updatedBy;
    private final String targetLifecycleStatus;
    private final HostPropertiesResponse hostProperties;
    private final LogConfiguration workerLog;

    private GetSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.fleetId = builder.fleetId;
        this.workerId = builder.workerId;
        this.startedAt = builder.startedAt;
        this.log = builder.log;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.endedAt = builder.endedAt;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.targetLifecycleStatus = builder.targetLifecycleStatus;
        this.hostProperties = builder.hostProperties;
        this.workerLog = builder.workerLog;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String workerId() {
        return this.workerId;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final LogConfiguration log() {
        return this.log;
    }

    public final SessionLifecycleStatus lifecycleStatus() {
        return SessionLifecycleStatus.fromValue(this.lifecycleStatus);
    }

    public final String lifecycleStatusAsString() {
        return this.lifecycleStatus;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final SessionLifecycleTargetStatus targetLifecycleStatus() {
        return SessionLifecycleTargetStatus.fromValue(this.targetLifecycleStatus);
    }

    public final String targetLifecycleStatusAsString() {
        return this.targetLifecycleStatus;
    }

    public final HostPropertiesResponse hostProperties() {
        return this.hostProperties;
    }

    public final LogConfiguration workerLog() {
        return this.workerLog;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.log());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerLog());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponse)) {
            return false;
        }
        GetSessionResponse other = (GetSessionResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.log(), other.log()) && Objects.equals(this.lifecycleStatusAsString(), other.lifecycleStatusAsString()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.targetLifecycleStatusAsString(), other.targetLifecycleStatusAsString()) && Objects.equals(this.hostProperties(), other.hostProperties()) && Objects.equals(this.workerLog(), other.workerLog());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionResponse").add("SessionId", (Object)this.sessionId()).add("FleetId", (Object)this.fleetId()).add("WorkerId", (Object)this.workerId()).add("StartedAt", (Object)this.startedAt()).add("Log", (Object)this.log()).add("LifecycleStatus", (Object)this.lifecycleStatusAsString()).add("EndedAt", (Object)this.endedAt()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("TargetLifecycleStatus", (Object)this.targetLifecycleStatusAsString()).add("HostProperties", (Object)this.hostProperties()).add("WorkerLog", (Object)this.workerLog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "fleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "workerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "log": {
                return Optional.ofNullable(clazz.cast(this.log()));
            }
            case "lifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusAsString()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "targetLifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.targetLifecycleStatusAsString()));
            }
            case "hostProperties": {
                return Optional.ofNullable(clazz.cast(this.hostProperties()));
            }
            case "workerLog": {
                return Optional.ofNullable(clazz.cast(this.workerLog()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("fleetId", FLEET_ID_FIELD);
        map.put("workerId", WORKER_ID_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("log", LOG_FIELD);
        map.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("targetLifecycleStatus", TARGET_LIFECYCLE_STATUS_FIELD);
        map.put("hostProperties", HOST_PROPERTIES_FIELD);
        map.put("workerLog", WORKER_LOG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponse, T> g) {
        return obj -> g.apply((GetSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private String fleetId;
        private String workerId;
        private Instant startedAt;
        private LogConfiguration log;
        private String lifecycleStatus;
        private Instant endedAt;
        private Instant updatedAt;
        private String updatedBy;
        private String targetLifecycleStatus;
        private HostPropertiesResponse hostProperties;
        private LogConfiguration workerLog;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.fleetId(model.fleetId);
            this.workerId(model.workerId);
            this.startedAt(model.startedAt);
            this.log(model.log);
            this.lifecycleStatus(model.lifecycleStatus);
            this.endedAt(model.endedAt);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.targetLifecycleStatus(model.targetLifecycleStatus);
            this.hostProperties(model.hostProperties);
            this.workerLog(model.workerLog);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final LogConfiguration.Builder getLog() {
            return this.log != null ? this.log.toBuilder() : null;
        }

        public final void setLog(LogConfiguration.BuilderImpl log) {
            this.log = log != null ? log.build() : null;
        }

        @Override
        public final Builder log(LogConfiguration log) {
            this.log = log;
            return this;
        }

        public final String getLifecycleStatus() {
            return this.lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(SessionLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getTargetLifecycleStatus() {
            return this.targetLifecycleStatus;
        }

        public final void setTargetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
        }

        @Override
        public final Builder targetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
            return this;
        }

        @Override
        public final Builder targetLifecycleStatus(SessionLifecycleTargetStatus targetLifecycleStatus) {
            this.targetLifecycleStatus(targetLifecycleStatus == null ? null : targetLifecycleStatus.toString());
            return this;
        }

        public final HostPropertiesResponse.Builder getHostProperties() {
            return this.hostProperties != null ? this.hostProperties.toBuilder() : null;
        }

        public final void setHostProperties(HostPropertiesResponse.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        @Override
        public final Builder hostProperties(HostPropertiesResponse hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final LogConfiguration.Builder getWorkerLog() {
            return this.workerLog != null ? this.workerLog.toBuilder() : null;
        }

        public final void setWorkerLog(LogConfiguration.BuilderImpl workerLog) {
            this.workerLog = workerLog != null ? workerLog.build() : null;
        }

        @Override
        public final Builder workerLog(LogConfiguration workerLog) {
            this.workerLog = workerLog;
            return this;
        }

        @Override
        public GetSessionResponse build() {
            return new GetSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionResponse> {
        public Builder sessionId(String var1);

        public Builder fleetId(String var1);

        public Builder workerId(String var1);

        public Builder startedAt(Instant var1);

        public Builder log(LogConfiguration var1);

        default public Builder log(Consumer<LogConfiguration.Builder> log) {
            return this.log((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(log)).build());
        }

        public Builder lifecycleStatus(String var1);

        public Builder lifecycleStatus(SessionLifecycleStatus var1);

        public Builder endedAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder targetLifecycleStatus(String var1);

        public Builder targetLifecycleStatus(SessionLifecycleTargetStatus var1);

        public Builder hostProperties(HostPropertiesResponse var1);

        default public Builder hostProperties(Consumer<HostPropertiesResponse.Builder> hostProperties) {
            return this.hostProperties((HostPropertiesResponse)((HostPropertiesResponse.Builder)HostPropertiesResponse.builder().applyMutation(hostProperties)).build());
        }

        public Builder workerLog(LogConfiguration var1);

        default public Builder workerLog(Consumer<LogConfiguration.Builder> workerLog) {
            return this.workerLog((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(workerLog)).build());
        }
    }
}

