/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskParameterValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskParameterValue> {
    private static final SdkField<String> INT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("int").getter(TaskParameterValue.getter(TaskParameterValue::intValue)).setter(TaskParameterValue.setter(Builder::intValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("int").build()}).build();
    private static final SdkField<String> FLOAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("float").getter(TaskParameterValue.getter(TaskParameterValue::floatValue)).setter(TaskParameterValue.setter(Builder::floatValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("float").build()}).build();
    private static final SdkField<String> STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("string").getter(TaskParameterValue.getter(TaskParameterValue::string)).setter(TaskParameterValue.setter(Builder::string)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("string").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(TaskParameterValue.getter(TaskParameterValue::path)).setter(TaskParameterValue.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INT_FIELD, FLOAT_FIELD, STRING_FIELD, PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskParameterValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String intValue;
    private final String floatValue;
    private final String string;
    private final String path;
    private final Type type;

    private TaskParameterValue(BuilderImpl builder) {
        this.intValue = builder.intValue;
        this.floatValue = builder.floatValue;
        this.string = builder.string;
        this.path = builder.path;
        this.type = builder.type;
    }

    public final String intValue() {
        return this.intValue;
    }

    public final String floatValue() {
        return this.floatValue;
    }

    public final String string() {
        return this.string;
    }

    public final String path() {
        return this.path;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.floatValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.string());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskParameterValue)) {
            return false;
        }
        TaskParameterValue other = (TaskParameterValue)obj;
        return Objects.equals(this.intValue(), other.intValue()) && Objects.equals(this.floatValue(), other.floatValue()) && Objects.equals(this.string(), other.string()) && Objects.equals(this.path(), other.path());
    }

    public final String toString() {
        return ToString.builder((String)"TaskParameterValue").add("Int", (Object)this.intValue()).add("Float", (Object)this.floatValue()).add("String", (Object)this.string()).add("Path", (Object)this.path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "int": {
                return Optional.ofNullable(clazz.cast(this.intValue()));
            }
            case "float": {
                return Optional.ofNullable(clazz.cast(this.floatValue()));
            }
            case "string": {
                return Optional.ofNullable(clazz.cast(this.string()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
        }
        return Optional.empty();
    }

    public static TaskParameterValue fromIntValue(String intValue) {
        return (TaskParameterValue)TaskParameterValue.builder().intValue(intValue).build();
    }

    public static TaskParameterValue fromFloatValue(String floatValue) {
        return (TaskParameterValue)TaskParameterValue.builder().floatValue(floatValue).build();
    }

    public static TaskParameterValue fromString(String string) {
        return (TaskParameterValue)TaskParameterValue.builder().string(string).build();
    }

    public static TaskParameterValue fromPath(String path) {
        return (TaskParameterValue)TaskParameterValue.builder().path(path).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("int", INT_FIELD);
        map.put("float", FLOAT_FIELD);
        map.put("string", STRING_FIELD);
        map.put("path", PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskParameterValue, T> g) {
        return obj -> g.apply((TaskParameterValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INT,
        FLOAT,
        STRING,
        PATH,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String intValue;
        private String floatValue;
        private String string;
        private String path;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TaskParameterValue model) {
            this.intValue(model.intValue);
            this.floatValue(model.floatValue);
            this.string(model.string);
            this.path(model.path);
        }

        public final String getIntValue() {
            return this.intValue;
        }

        public final void setIntValue(String intValue) {
            String oldValue = this.intValue;
            this.intValue = intValue;
            this.handleUnionValueChange(Type.INT, oldValue, this.intValue);
        }

        @Override
        public final Builder intValue(String intValue) {
            String oldValue = this.intValue;
            this.intValue = intValue;
            this.handleUnionValueChange(Type.INT, oldValue, this.intValue);
            return this;
        }

        public final String getFloatValue() {
            return this.floatValue;
        }

        public final void setFloatValue(String floatValue) {
            String oldValue = this.floatValue;
            this.floatValue = floatValue;
            this.handleUnionValueChange(Type.FLOAT, oldValue, this.floatValue);
        }

        @Override
        public final Builder floatValue(String floatValue) {
            String oldValue = this.floatValue;
            this.floatValue = floatValue;
            this.handleUnionValueChange(Type.FLOAT, oldValue, this.floatValue);
            return this;
        }

        public final String getString() {
            return this.string;
        }

        public final void setString(String string) {
            String oldValue = this.string;
            this.string = string;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(String string) {
            String oldValue = this.string;
            this.string = string;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            String oldValue = this.path;
            this.path = path;
            this.handleUnionValueChange(Type.PATH, oldValue, this.path);
        }

        @Override
        public final Builder path(String path) {
            String oldValue = this.path;
            this.path = path;
            this.handleUnionValueChange(Type.PATH, oldValue, this.path);
            return this;
        }

        public TaskParameterValue build() {
            return new TaskParameterValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskParameterValue> {
        public Builder intValue(String var1);

        public Builder floatValue(String var1);

        public Builder string(String var1);

        public Builder path(String var1);
    }
}

