/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.StepTargetTaskRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStepRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateStepRequest> {
    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetTaskRunStatus").getter(UpdateStepRequest.getter(UpdateStepRequest::targetTaskRunStatusAsString)).setter(UpdateStepRequest.setter(Builder::targetTaskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateStepRequest.getter(UpdateStepRequest::clientToken)).setter(UpdateStepRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateStepRequest.getter(UpdateStepRequest::farmId)).setter(UpdateStepRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(UpdateStepRequest.getter(UpdateStepRequest::queueId)).setter(UpdateStepRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(UpdateStepRequest.getter(UpdateStepRequest::jobId)).setter(UpdateStepRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(UpdateStepRequest.getter(UpdateStepRequest::stepId)).setter(UpdateStepRequest.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("stepId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TASK_RUN_STATUS_FIELD, CLIENT_TOKEN_FIELD, FARM_ID_FIELD, QUEUE_ID_FIELD, JOB_ID_FIELD, STEP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateStepRequest.memberNameToFieldInitializer();
    private final String targetTaskRunStatus;
    private final String clientToken;
    private final String farmId;
    private final String queueId;
    private final String jobId;
    private final String stepId;

    private UpdateStepRequest(BuilderImpl builder) {
        super(builder);
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.jobId = builder.jobId;
        this.stepId = builder.stepId;
    }

    public final StepTargetTaskRunStatus targetTaskRunStatus() {
        return StepTargetTaskRunStatus.fromValue(this.targetTaskRunStatus);
    }

    public final String targetTaskRunStatusAsString() {
        return this.targetTaskRunStatus;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String stepId() {
        return this.stepId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStepRequest)) {
            return false;
        }
        UpdateStepRequest other = (UpdateStepRequest)((Object)obj);
        return Objects.equals(this.targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.stepId(), other.stepId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStepRequest").add("TargetTaskRunStatus", (Object)this.targetTaskRunStatusAsString()).add("ClientToken", (Object)this.clientToken()).add("FarmId", (Object)this.farmId()).add("QueueId", (Object)this.queueId()).add("JobId", (Object)this.jobId()).add("StepId", (Object)this.stepId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetTaskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.targetTaskRunStatusAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("targetTaskRunStatus", TARGET_TASK_RUN_STATUS_FIELD);
        map.put("X-Amz-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("stepId", STEP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStepRequest, T> g) {
        return obj -> g.apply((UpdateStepRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String targetTaskRunStatus;
        private String clientToken;
        private String farmId;
        private String queueId;
        private String jobId;
        private String stepId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStepRequest model) {
            super(model);
            this.targetTaskRunStatus(model.targetTaskRunStatus);
            this.clientToken(model.clientToken);
            this.farmId(model.farmId);
            this.queueId(model.queueId);
            this.jobId(model.jobId);
            this.stepId(model.stepId);
        }

        public final String getTargetTaskRunStatus() {
            return this.targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(StepTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStepRequest build() {
            return new UpdateStepRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStepRequest> {
        public Builder targetTaskRunStatus(String var1);

        public Builder targetTaskRunStatus(StepTargetTaskRunStatus var1);

        public Builder clientToken(String var1);

        public Builder farmId(String var1);

        public Builder queueId(String var1);

        public Builder jobId(String var1);

        public Builder stepId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

