/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.OutputRelativeDirectoriesListCopier;
import software.amazon.awssdk.services.deadline.model.PathFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManifestProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManifestProperties> {
    private static final SdkField<String> FILE_SYSTEM_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileSystemLocationName").getter(ManifestProperties.getter(ManifestProperties::fileSystemLocationName)).setter(ManifestProperties.setter(Builder::fileSystemLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocationName").build()}).build();
    private static final SdkField<String> ROOT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rootPath").getter(ManifestProperties.getter(ManifestProperties::rootPath)).setter(ManifestProperties.setter(Builder::rootPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootPath").build()}).build();
    private static final SdkField<String> ROOT_PATH_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rootPathFormat").getter(ManifestProperties.getter(ManifestProperties::rootPathFormatAsString)).setter(ManifestProperties.setter(Builder::rootPathFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootPathFormat").build()}).build();
    private static final SdkField<List<String>> OUTPUT_RELATIVE_DIRECTORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputRelativeDirectories").getter(ManifestProperties.getter(ManifestProperties::outputRelativeDirectories)).setter(ManifestProperties.setter(Builder::outputRelativeDirectories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputRelativeDirectories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_MANIFEST_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputManifestPath").getter(ManifestProperties.getter(ManifestProperties::inputManifestPath)).setter(ManifestProperties.setter(Builder::inputManifestPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputManifestPath").build()}).build();
    private static final SdkField<String> INPUT_MANIFEST_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputManifestHash").getter(ManifestProperties.getter(ManifestProperties::inputManifestHash)).setter(ManifestProperties.setter(Builder::inputManifestHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputManifestHash").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_LOCATION_NAME_FIELD, ROOT_PATH_FIELD, ROOT_PATH_FORMAT_FIELD, OUTPUT_RELATIVE_DIRECTORIES_FIELD, INPUT_MANIFEST_PATH_FIELD, INPUT_MANIFEST_HASH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManifestProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fileSystemLocationName;
    private final String rootPath;
    private final String rootPathFormat;
    private final List<String> outputRelativeDirectories;
    private final String inputManifestPath;
    private final String inputManifestHash;

    private ManifestProperties(BuilderImpl builder) {
        this.fileSystemLocationName = builder.fileSystemLocationName;
        this.rootPath = builder.rootPath;
        this.rootPathFormat = builder.rootPathFormat;
        this.outputRelativeDirectories = builder.outputRelativeDirectories;
        this.inputManifestPath = builder.inputManifestPath;
        this.inputManifestHash = builder.inputManifestHash;
    }

    public final String fileSystemLocationName() {
        return this.fileSystemLocationName;
    }

    public final String rootPath() {
        return this.rootPath;
    }

    public final PathFormat rootPathFormat() {
        return PathFormat.fromValue(this.rootPathFormat);
    }

    public final String rootPathFormatAsString() {
        return this.rootPathFormat;
    }

    public final boolean hasOutputRelativeDirectories() {
        return this.outputRelativeDirectories != null && !(this.outputRelativeDirectories instanceof SdkAutoConstructList);
    }

    public final List<String> outputRelativeDirectories() {
        return this.outputRelativeDirectories;
    }

    public final String inputManifestPath() {
        return this.inputManifestPath;
    }

    public final String inputManifestHash() {
        return this.inputManifestHash;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootPathFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputRelativeDirectories() ? this.outputRelativeDirectories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputManifestPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputManifestHash());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManifestProperties)) {
            return false;
        }
        ManifestProperties other = (ManifestProperties)obj;
        return Objects.equals(this.fileSystemLocationName(), other.fileSystemLocationName()) && Objects.equals(this.rootPath(), other.rootPath()) && Objects.equals(this.rootPathFormatAsString(), other.rootPathFormatAsString()) && this.hasOutputRelativeDirectories() == other.hasOutputRelativeDirectories() && Objects.equals(this.outputRelativeDirectories(), other.outputRelativeDirectories()) && Objects.equals(this.inputManifestPath(), other.inputManifestPath()) && Objects.equals(this.inputManifestHash(), other.inputManifestHash());
    }

    public final String toString() {
        return ToString.builder((String)"ManifestProperties").add("FileSystemLocationName", (Object)(this.fileSystemLocationName() == null ? null : "*** Sensitive Data Redacted ***")).add("RootPath", (Object)this.rootPath()).add("RootPathFormat", (Object)this.rootPathFormatAsString()).add("OutputRelativeDirectories", this.hasOutputRelativeDirectories() ? this.outputRelativeDirectories() : null).add("InputManifestPath", (Object)this.inputManifestPath()).add("InputManifestHash", (Object)this.inputManifestHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileSystemLocationName": {
                return Optional.ofNullable(clazz.cast(this.fileSystemLocationName()));
            }
            case "rootPath": {
                return Optional.ofNullable(clazz.cast(this.rootPath()));
            }
            case "rootPathFormat": {
                return Optional.ofNullable(clazz.cast(this.rootPathFormatAsString()));
            }
            case "outputRelativeDirectories": {
                return Optional.ofNullable(clazz.cast(this.outputRelativeDirectories()));
            }
            case "inputManifestPath": {
                return Optional.ofNullable(clazz.cast(this.inputManifestPath()));
            }
            case "inputManifestHash": {
                return Optional.ofNullable(clazz.cast(this.inputManifestHash()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileSystemLocationName", FILE_SYSTEM_LOCATION_NAME_FIELD);
        map.put("rootPath", ROOT_PATH_FIELD);
        map.put("rootPathFormat", ROOT_PATH_FORMAT_FIELD);
        map.put("outputRelativeDirectories", OUTPUT_RELATIVE_DIRECTORIES_FIELD);
        map.put("inputManifestPath", INPUT_MANIFEST_PATH_FIELD);
        map.put("inputManifestHash", INPUT_MANIFEST_HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManifestProperties, T> g) {
        return obj -> g.apply((ManifestProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemLocationName;
        private String rootPath;
        private String rootPathFormat;
        private List<String> outputRelativeDirectories = DefaultSdkAutoConstructList.getInstance();
        private String inputManifestPath;
        private String inputManifestHash;

        private BuilderImpl() {
        }

        private BuilderImpl(ManifestProperties model) {
            this.fileSystemLocationName(model.fileSystemLocationName);
            this.rootPath(model.rootPath);
            this.rootPathFormat(model.rootPathFormat);
            this.outputRelativeDirectories(model.outputRelativeDirectories);
            this.inputManifestPath(model.inputManifestPath);
            this.inputManifestHash(model.inputManifestHash);
        }

        public final String getFileSystemLocationName() {
            return this.fileSystemLocationName;
        }

        public final void setFileSystemLocationName(String fileSystemLocationName) {
            this.fileSystemLocationName = fileSystemLocationName;
        }

        @Override
        public final Builder fileSystemLocationName(String fileSystemLocationName) {
            this.fileSystemLocationName = fileSystemLocationName;
            return this;
        }

        public final String getRootPath() {
            return this.rootPath;
        }

        public final void setRootPath(String rootPath) {
            this.rootPath = rootPath;
        }

        @Override
        public final Builder rootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public final String getRootPathFormat() {
            return this.rootPathFormat;
        }

        public final void setRootPathFormat(String rootPathFormat) {
            this.rootPathFormat = rootPathFormat;
        }

        @Override
        public final Builder rootPathFormat(String rootPathFormat) {
            this.rootPathFormat = rootPathFormat;
            return this;
        }

        @Override
        public final Builder rootPathFormat(PathFormat rootPathFormat) {
            this.rootPathFormat(rootPathFormat == null ? null : rootPathFormat.toString());
            return this;
        }

        public final Collection<String> getOutputRelativeDirectories() {
            if (this.outputRelativeDirectories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputRelativeDirectories;
        }

        public final void setOutputRelativeDirectories(Collection<String> outputRelativeDirectories) {
            this.outputRelativeDirectories = OutputRelativeDirectoriesListCopier.copy(outputRelativeDirectories);
        }

        @Override
        public final Builder outputRelativeDirectories(Collection<String> outputRelativeDirectories) {
            this.outputRelativeDirectories = OutputRelativeDirectoriesListCopier.copy(outputRelativeDirectories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputRelativeDirectories(String ... outputRelativeDirectories) {
            this.outputRelativeDirectories(Arrays.asList(outputRelativeDirectories));
            return this;
        }

        public final String getInputManifestPath() {
            return this.inputManifestPath;
        }

        public final void setInputManifestPath(String inputManifestPath) {
            this.inputManifestPath = inputManifestPath;
        }

        @Override
        public final Builder inputManifestPath(String inputManifestPath) {
            this.inputManifestPath = inputManifestPath;
            return this;
        }

        public final String getInputManifestHash() {
            return this.inputManifestHash;
        }

        public final void setInputManifestHash(String inputManifestHash) {
            this.inputManifestHash = inputManifestHash;
        }

        @Override
        public final Builder inputManifestHash(String inputManifestHash) {
            this.inputManifestHash = inputManifestHash;
            return this;
        }

        public ManifestProperties build() {
            return new ManifestProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManifestProperties> {
        public Builder fileSystemLocationName(String var1);

        public Builder rootPath(String var1);

        public Builder rootPathFormat(String var1);

        public Builder rootPathFormat(PathFormat var1);

        public Builder outputRelativeDirectories(Collection<String> var1);

        public Builder outputRelativeDirectories(String ... var1);

        public Builder inputManifestPath(String var1);

        public Builder inputManifestHash(String var1);
    }
}

