/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.FarmMember;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListFarmMembersResponse;

public class ListFarmMembersIterable
implements SdkIterable<ListFarmMembersResponse> {
    private final DeadlineClient client;
    private final ListFarmMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFarmMembersIterable(DeadlineClient client, ListFarmMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFarmMembersResponseFetcher();
    }

    public Iterator<ListFarmMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FarmMember> members() {
        Function<ListFarmMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFarmMembersResponseFetcher
    implements SyncPageFetcher<ListFarmMembersResponse> {
        private ListFarmMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListFarmMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFarmMembersResponse nextPage(ListFarmMembersResponse previousPage) {
            if (previousPage == null) {
                return ListFarmMembersIterable.this.client.listFarmMembers(ListFarmMembersIterable.this.firstRequest);
            }
            return ListFarmMembersIterable.this.client.listFarmMembers((ListFarmMembersRequest)((Object)ListFarmMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

