/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.BudgetActionToAdd;
import software.amazon.awssdk.services.deadline.model.BudgetActionToRemove;
import software.amazon.awssdk.services.deadline.model.BudgetActionsToAddCopier;
import software.amazon.awssdk.services.deadline.model.BudgetActionsToRemoveCopier;
import software.amazon.awssdk.services.deadline.model.BudgetSchedule;
import software.amazon.awssdk.services.deadline.model.BudgetStatus;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBudgetRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateBudgetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::clientToken)).setter(UpdateBudgetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::farmId)).setter(UpdateBudgetRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> BUDGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("budgetId").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::budgetId)).setter(UpdateBudgetRequest.setter(Builder::budgetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("budgetId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::displayName)).setter(UpdateBudgetRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::description)).setter(UpdateBudgetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::statusAsString)).setter(UpdateBudgetRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Float> APPROXIMATE_DOLLAR_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("approximateDollarLimit").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::approximateDollarLimit)).setter(UpdateBudgetRequest.setter(Builder::approximateDollarLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateDollarLimit").build()}).build();
    private static final SdkField<List<BudgetActionToAdd>> ACTIONS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionsToAdd").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::actionsToAdd)).setter(UpdateBudgetRequest.setter(Builder::actionsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BudgetActionToAdd::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BudgetActionToRemove>> ACTIONS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionsToRemove").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::actionsToRemove)).setter(UpdateBudgetRequest.setter(Builder::actionsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BudgetActionToRemove::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BudgetSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(UpdateBudgetRequest.getter(UpdateBudgetRequest::schedule)).setter(UpdateBudgetRequest.setter(Builder::schedule)).constructor(BudgetSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, FARM_ID_FIELD, BUDGET_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, APPROXIMATE_DOLLAR_LIMIT_FIELD, ACTIONS_TO_ADD_FIELD, ACTIONS_TO_REMOVE_FIELD, SCHEDULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("X-Amz-Client-Token", CLIENT_TOKEN_FIELD);
            this.put("farmId", FARM_ID_FIELD);
            this.put("budgetId", BUDGET_ID_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("approximateDollarLimit", APPROXIMATE_DOLLAR_LIMIT_FIELD);
            this.put("actionsToAdd", ACTIONS_TO_ADD_FIELD);
            this.put("actionsToRemove", ACTIONS_TO_REMOVE_FIELD);
            this.put("schedule", SCHEDULE_FIELD);
        }
    });
    private final String clientToken;
    private final String farmId;
    private final String budgetId;
    private final String displayName;
    private final String description;
    private final String status;
    private final Float approximateDollarLimit;
    private final List<BudgetActionToAdd> actionsToAdd;
    private final List<BudgetActionToRemove> actionsToRemove;
    private final BudgetSchedule schedule;

    private UpdateBudgetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.budgetId = builder.budgetId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.status = builder.status;
        this.approximateDollarLimit = builder.approximateDollarLimit;
        this.actionsToAdd = builder.actionsToAdd;
        this.actionsToRemove = builder.actionsToRemove;
        this.schedule = builder.schedule;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String budgetId() {
        return this.budgetId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final BudgetStatus status() {
        return BudgetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Float approximateDollarLimit() {
        return this.approximateDollarLimit;
    }

    public final boolean hasActionsToAdd() {
        return this.actionsToAdd != null && !(this.actionsToAdd instanceof SdkAutoConstructList);
    }

    public final List<BudgetActionToAdd> actionsToAdd() {
        return this.actionsToAdd;
    }

    public final boolean hasActionsToRemove() {
        return this.actionsToRemove != null && !(this.actionsToRemove instanceof SdkAutoConstructList);
    }

    public final List<BudgetActionToRemove> actionsToRemove() {
        return this.actionsToRemove;
    }

    public final BudgetSchedule schedule() {
        return this.schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateDollarLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionsToAdd() ? this.actionsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionsToRemove() ? this.actionsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetRequest)) {
            return false;
        }
        UpdateBudgetRequest other = (UpdateBudgetRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.budgetId(), other.budgetId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.approximateDollarLimit(), other.approximateDollarLimit()) && this.hasActionsToAdd() == other.hasActionsToAdd() && Objects.equals(this.actionsToAdd(), other.actionsToAdd()) && this.hasActionsToRemove() == other.hasActionsToRemove() && Objects.equals(this.actionsToRemove(), other.actionsToRemove()) && Objects.equals(this.schedule(), other.schedule());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBudgetRequest").add("ClientToken", (Object)this.clientToken()).add("FarmId", (Object)this.farmId()).add("BudgetId", (Object)this.budgetId()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("ApproximateDollarLimit", (Object)this.approximateDollarLimit()).add("ActionsToAdd", this.hasActionsToAdd() ? this.actionsToAdd() : null).add("ActionsToRemove", this.hasActionsToRemove() ? this.actionsToRemove() : null).add("Schedule", (Object)this.schedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "budgetId": {
                return Optional.ofNullable(clazz.cast(this.budgetId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "approximateDollarLimit": {
                return Optional.ofNullable(clazz.cast(this.approximateDollarLimit()));
            }
            case "actionsToAdd": {
                return Optional.ofNullable(clazz.cast(this.actionsToAdd()));
            }
            case "actionsToRemove": {
                return Optional.ofNullable(clazz.cast(this.actionsToRemove()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBudgetRequest, T> g) {
        return obj -> g.apply((UpdateBudgetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String farmId;
        private String budgetId;
        private String displayName;
        private String description;
        private String status;
        private Float approximateDollarLimit;
        private List<BudgetActionToAdd> actionsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<BudgetActionToRemove> actionsToRemove = DefaultSdkAutoConstructList.getInstance();
        private BudgetSchedule schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.farmId(model.farmId);
            this.budgetId(model.budgetId);
            this.displayName(model.displayName);
            this.description(model.description);
            this.status(model.status);
            this.approximateDollarLimit(model.approximateDollarLimit);
            this.actionsToAdd(model.actionsToAdd);
            this.actionsToRemove(model.actionsToRemove);
            this.schedule(model.schedule);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getBudgetId() {
            return this.budgetId;
        }

        public final void setBudgetId(String budgetId) {
            this.budgetId = budgetId;
        }

        @Override
        public final Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BudgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Float getApproximateDollarLimit() {
            return this.approximateDollarLimit;
        }

        public final void setApproximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
        }

        @Override
        public final Builder approximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
            return this;
        }

        public final List<BudgetActionToAdd.Builder> getActionsToAdd() {
            List<BudgetActionToAdd.Builder> result = BudgetActionsToAddCopier.copyToBuilder(this.actionsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionsToAdd(Collection<BudgetActionToAdd.BuilderImpl> actionsToAdd) {
            this.actionsToAdd = BudgetActionsToAddCopier.copyFromBuilder(actionsToAdd);
        }

        @Override
        public final Builder actionsToAdd(Collection<BudgetActionToAdd> actionsToAdd) {
            this.actionsToAdd = BudgetActionsToAddCopier.copy(actionsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsToAdd(BudgetActionToAdd ... actionsToAdd) {
            this.actionsToAdd(Arrays.asList(actionsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsToAdd(Consumer<BudgetActionToAdd.Builder> ... actionsToAdd) {
            this.actionsToAdd(Stream.of(actionsToAdd).map(c -> (BudgetActionToAdd)((BudgetActionToAdd.Builder)BudgetActionToAdd.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BudgetActionToRemove.Builder> getActionsToRemove() {
            List<BudgetActionToRemove.Builder> result = BudgetActionsToRemoveCopier.copyToBuilder(this.actionsToRemove);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionsToRemove(Collection<BudgetActionToRemove.BuilderImpl> actionsToRemove) {
            this.actionsToRemove = BudgetActionsToRemoveCopier.copyFromBuilder(actionsToRemove);
        }

        @Override
        public final Builder actionsToRemove(Collection<BudgetActionToRemove> actionsToRemove) {
            this.actionsToRemove = BudgetActionsToRemoveCopier.copy(actionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsToRemove(BudgetActionToRemove ... actionsToRemove) {
            this.actionsToRemove(Arrays.asList(actionsToRemove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsToRemove(Consumer<BudgetActionToRemove.Builder> ... actionsToRemove) {
            this.actionsToRemove(Stream.of(actionsToRemove).map(c -> (BudgetActionToRemove)((BudgetActionToRemove.Builder)BudgetActionToRemove.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BudgetSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(BudgetSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(BudgetSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBudgetRequest build() {
            return new UpdateBudgetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBudgetRequest> {
        public Builder clientToken(String var1);

        public Builder farmId(String var1);

        public Builder budgetId(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(BudgetStatus var1);

        public Builder approximateDollarLimit(Float var1);

        public Builder actionsToAdd(Collection<BudgetActionToAdd> var1);

        public Builder actionsToAdd(BudgetActionToAdd ... var1);

        public Builder actionsToAdd(Consumer<BudgetActionToAdd.Builder> ... var1);

        public Builder actionsToRemove(Collection<BudgetActionToRemove> var1);

        public Builder actionsToRemove(BudgetActionToRemove ... var1);

        public Builder actionsToRemove(Consumer<BudgetActionToRemove.Builder> ... var1);

        public Builder schedule(BudgetSchedule var1);

        default public Builder schedule(Consumer<BudgetSchedule.Builder> schedule) {
            return this.schedule((BudgetSchedule)((BudgetSchedule.Builder)BudgetSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

