/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.SessionsStatisticsResourcesFleetIdsListCopier;
import software.amazon.awssdk.services.deadline.model.SessionsStatisticsResourcesQueueIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionsStatisticsResources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionsStatisticsResources> {
    private static final SdkField<List<String>> QUEUE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queueIds").getter(SessionsStatisticsResources.getter(SessionsStatisticsResources::queueIds)).setter(SessionsStatisticsResources.setter(Builder::queueIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FLEET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fleetIds").getter(SessionsStatisticsResources.getter(SessionsStatisticsResources::fleetIds)).setter(SessionsStatisticsResources.setter(Builder::fleetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_IDS_FIELD, FLEET_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("queueIds", QUEUE_IDS_FIELD);
            this.put("fleetIds", FLEET_IDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> queueIds;
    private final List<String> fleetIds;
    private final Type type;

    private SessionsStatisticsResources(BuilderImpl builder) {
        this.queueIds = builder.queueIds;
        this.fleetIds = builder.fleetIds;
        this.type = builder.type;
    }

    public final boolean hasQueueIds() {
        return this.queueIds != null && !(this.queueIds instanceof SdkAutoConstructList);
    }

    public final List<String> queueIds() {
        return this.queueIds;
    }

    public final boolean hasFleetIds() {
        return this.fleetIds != null && !(this.fleetIds instanceof SdkAutoConstructList);
    }

    public final List<String> fleetIds() {
        return this.fleetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueueIds() ? this.queueIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetIds() ? this.fleetIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionsStatisticsResources)) {
            return false;
        }
        SessionsStatisticsResources other = (SessionsStatisticsResources)obj;
        return this.hasQueueIds() == other.hasQueueIds() && Objects.equals(this.queueIds(), other.queueIds()) && this.hasFleetIds() == other.hasFleetIds() && Objects.equals(this.fleetIds(), other.fleetIds());
    }

    public final String toString() {
        return ToString.builder((String)"SessionsStatisticsResources").add("QueueIds", this.hasQueueIds() ? this.queueIds() : null).add("FleetIds", this.hasFleetIds() ? this.fleetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queueIds": {
                return Optional.ofNullable(clazz.cast(this.queueIds()));
            }
            case "fleetIds": {
                return Optional.ofNullable(clazz.cast(this.fleetIds()));
            }
        }
        return Optional.empty();
    }

    public static SessionsStatisticsResources fromQueueIds(List<String> queueIds) {
        return (SessionsStatisticsResources)SessionsStatisticsResources.builder().queueIds(queueIds).build();
    }

    public static SessionsStatisticsResources fromFleetIds(List<String> fleetIds) {
        return (SessionsStatisticsResources)SessionsStatisticsResources.builder().fleetIds(fleetIds).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SessionsStatisticsResources, T> g) {
        return obj -> g.apply((SessionsStatisticsResources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        QUEUE_IDS,
        FLEET_IDS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<String> queueIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionsStatisticsResources model) {
            this.queueIds(model.queueIds);
            this.fleetIds(model.fleetIds);
        }

        public final Collection<String> getQueueIds() {
            if (this.queueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queueIds;
        }

        public final void setQueueIds(Collection<String> queueIds) {
            List<String> oldValue = this.queueIds;
            this.queueIds = SessionsStatisticsResourcesQueueIdsListCopier.copy(queueIds);
            this.handleUnionValueChange(Type.QUEUE_IDS, oldValue, this.queueIds);
        }

        @Override
        public final Builder queueIds(Collection<String> queueIds) {
            List<String> oldValue = this.queueIds;
            this.queueIds = SessionsStatisticsResourcesQueueIdsListCopier.copy(queueIds);
            this.handleUnionValueChange(Type.QUEUE_IDS, oldValue, this.queueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueIds(String ... queueIds) {
            this.queueIds(Arrays.asList(queueIds));
            return this;
        }

        public final Collection<String> getFleetIds() {
            if (this.fleetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fleetIds;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            List<String> oldValue = this.fleetIds;
            this.fleetIds = SessionsStatisticsResourcesFleetIdsListCopier.copy(fleetIds);
            this.handleUnionValueChange(Type.FLEET_IDS, oldValue, this.fleetIds);
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            List<String> oldValue = this.fleetIds;
            this.fleetIds = SessionsStatisticsResourcesFleetIdsListCopier.copy(fleetIds);
            this.handleUnionValueChange(Type.FLEET_IDS, oldValue, this.fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String ... fleetIds) {
            this.fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public SessionsStatisticsResources build() {
            return new SessionsStatisticsResources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionsStatisticsResources> {
        public Builder queueIds(Collection<String> var1);

        public Builder queueIds(String ... var1);

        public Builder fleetIds(Collection<String> var1);

        public Builder fleetIds(String ... var1);
    }
}

