/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.StorageProfileSummariesCopier;
import software.amazon.awssdk.services.deadline.model.StorageProfileSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStorageProfilesResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListStorageProfilesResponse> {
    private static final SdkField<List<StorageProfileSummary>> STORAGE_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("storageProfiles").getter(ListStorageProfilesResponse.getter(ListStorageProfilesResponse::storageProfiles)).setter(ListStorageProfilesResponse.setter(Builder::storageProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStorageProfilesResponse.getter(ListStorageProfilesResponse::nextToken)).setter(ListStorageProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_PROFILES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("storageProfiles", STORAGE_PROFILES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<StorageProfileSummary> storageProfiles;
    private final String nextToken;

    private ListStorageProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.storageProfiles = builder.storageProfiles;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStorageProfiles() {
        return this.storageProfiles != null && !(this.storageProfiles instanceof SdkAutoConstructList);
    }

    public final List<StorageProfileSummary> storageProfiles() {
        return this.storageProfiles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageProfiles() ? this.storageProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageProfilesResponse)) {
            return false;
        }
        ListStorageProfilesResponse other = (ListStorageProfilesResponse)((Object)obj);
        return this.hasStorageProfiles() == other.hasStorageProfiles() && Objects.equals(this.storageProfiles(), other.storageProfiles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStorageProfilesResponse").add("StorageProfiles", this.hasStorageProfiles() ? this.storageProfiles() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageProfiles": {
                return Optional.ofNullable(clazz.cast(this.storageProfiles()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListStorageProfilesResponse, T> g) {
        return obj -> g.apply((ListStorageProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<StorageProfileSummary> storageProfiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStorageProfilesResponse model) {
            super(model);
            this.storageProfiles(model.storageProfiles);
            this.nextToken(model.nextToken);
        }

        public final List<StorageProfileSummary.Builder> getStorageProfiles() {
            List<StorageProfileSummary.Builder> result = StorageProfileSummariesCopier.copyToBuilder(this.storageProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageProfiles(Collection<StorageProfileSummary.BuilderImpl> storageProfiles) {
            this.storageProfiles = StorageProfileSummariesCopier.copyFromBuilder(storageProfiles);
        }

        @Override
        public final Builder storageProfiles(Collection<StorageProfileSummary> storageProfiles) {
            this.storageProfiles = StorageProfileSummariesCopier.copy(storageProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageProfiles(StorageProfileSummary ... storageProfiles) {
            this.storageProfiles(Arrays.asList(storageProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageProfiles(Consumer<StorageProfileSummary.Builder> ... storageProfiles) {
            this.storageProfiles(Stream.of(storageProfiles).map(c -> (StorageProfileSummary)((StorageProfileSummary.Builder)StorageProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStorageProfilesResponse build() {
            return new ListStorageProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStorageProfilesResponse> {
        public Builder storageProfiles(Collection<StorageProfileSummary> var1);

        public Builder storageProfiles(StorageProfileSummary ... var1);

        public Builder storageProfiles(Consumer<StorageProfileSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

